# Contributing to Xbyak

Thank you for considering contributing to the Xbyak project. This document provides guidelines on how to contribute.

## Bug Reports and Feedback

If you find a bug, have a feature request, or have questions, please open an issue. Include the following information:

- Detailed description of the problem
- Steps to reproduce
- Expected behavior
- Actual behavior
- Environment details (OS, compiler version, etc.)

## Creating Pull Requests

If you want to add features or make fixes, follow these steps to create a pull request:

1. Fork the repository
2. Create a new branch: `git checkout -b my-feature-branch`
3. Make your changes
4. Run tests and ensure all tests pass
5. Commit your changes: `git commit -am 'Add new feature'`
6. Push the branch: `git push origin my-feature-branch`
7. Create a pull request

When creating a pull request, clearly describe the changes and include any related issue numbers.

## License

Xbyak is released under the BSD-3-Clause License. Any code contributions will be licensed under the same license.

