/*
 * Worldvisions Weaver Software:
 * Copyright (C) 2003 Net Integration Technologies, Inc.
 *
 * Oakley authentication for IPSec
 */

#include "wvoakley.h"

/* Group 1 prime */
static unsigned char group1_key[] =
{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2, 
  0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
  0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6, 
  0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
  0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
  0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
  0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9, 
  0xA6, 0x3A, 0x36, 0x20, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/* Group 2 prime */
static unsigned char group2_key[] = 
{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2, 
  0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
  0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6, 
  0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
  0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D, 
  0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
  0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9, 
  0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
  0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11, 
  0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE6, 0x53, 0x81,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

WvOakleyAuth::WvOakleyAuth(int group)
{
    switch (group)
    {
    case 1:
	dh = new WvDiffieHellman(group1_key, sizeof(group1_key), 
				 DH_GENERATOR_2);
	break;
    case 2:
	dh = new WvDiffieHellman(group2_key, sizeof(group2_key), 
				 DH_GENERATOR_2);
	break;
    case 3: case 4:
	/* We don't support any eliptic curve stuff. */
	break;
    }
    pub_len = dh->pub_key_len();
}

short WvOakleyAuth::public_len()
{
    return pub_len;
}

short WvOakleyAuth::get_public_key(WvBuf &outbuf, short len)
{
    return dh->get_public_value(outbuf, len);
}

void WvOakleyAuth::create_secret(WvBuf &_other_pub_key, short len)
{
    other_pub_key.put(_other_pub_key.peek(0, len), len);
    other_len = len;
    dh->create_secret(_other_pub_key, len, dh_secret);
    return;
}

short WvOakleyAuth::other_pub_len()
{
    return other_len;
}

short WvOakleyAuth::get_other_public_key(WvBuf &outbuf, short len)
{
    if (len > other_len)
	len = other_len;

    outbuf.put(other_pub_key.peek(0, len), len);
    return len;
}
