// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib_sys;
use gtk_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use TreeIter;
use TreeModelFlags;
use TreePath;

glib_wrapper! {
    pub struct TreeModel(Interface<gtk_sys::GtkTreeModel>);

    match fn {
        get_type => || gtk_sys::gtk_tree_model_get_type(),
    }
}

pub const NONE_TREE_MODEL: Option<&TreeModel> = None;

pub trait TreeModelExt: 'static {
    fn foreach<P: FnMut(&TreeModel, &TreePath, &TreeIter) -> bool>(&self, func: P);

    //fn get(&self, iter: &TreeIter, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs);

    fn get_column_type(&self, index_: i32) -> glib::types::Type;

    fn get_flags(&self) -> TreeModelFlags;

    fn get_iter(&self, path: &TreePath) -> Option<TreeIter>;

    fn get_iter_first(&self) -> Option<TreeIter>;

    fn get_iter_from_string(&self, path_string: &str) -> Option<TreeIter>;

    fn get_n_columns(&self) -> i32;

    fn get_path(&self, iter: &TreeIter) -> Option<TreePath>;

    fn get_string_from_iter(&self, iter: &TreeIter) -> Option<GString>;

    //fn get_valist(&self, iter: &TreeIter, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported);

    fn get_value(&self, iter: &TreeIter, column: i32) -> glib::Value;

    fn iter_children(&self, parent: Option<&TreeIter>) -> Option<TreeIter>;

    fn iter_has_child(&self, iter: &TreeIter) -> bool;

    fn iter_n_children(&self, iter: Option<&TreeIter>) -> i32;

    fn iter_next(&self, iter: &TreeIter) -> bool;

    fn iter_nth_child(&self, parent: Option<&TreeIter>, n: i32) -> Option<TreeIter>;

    fn iter_parent(&self, child: &TreeIter) -> Option<TreeIter>;

    fn iter_previous(&self, iter: &TreeIter) -> bool;

    fn row_changed(&self, path: &TreePath, iter: &TreeIter);

    fn row_deleted(&self, path: &TreePath);

    fn row_has_child_toggled(&self, path: &TreePath, iter: &TreeIter);

    fn row_inserted(&self, path: &TreePath, iter: &TreeIter);

    fn rows_reordered_with_length(
        &self,
        path: &TreePath,
        iter: Option<&TreeIter>,
        new_order: &[i32],
    );

    fn sort_new_with_model(&self) -> Option<TreeModel>;

    fn connect_row_changed<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_row_deleted<F: Fn(&Self, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_row_has_child_toggled<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_row_inserted<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    //fn connect_rows_reordered<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TreeModel>> TreeModelExt for O {
    fn foreach<P: FnMut(&TreeModel, &TreePath, &TreeIter) -> bool>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&TreeModel, &TreePath, &TreeIter) -> bool>(
            model: *mut gtk_sys::GtkTreeModel,
            path: *mut gtk_sys::GtkTreePath,
            iter: *mut gtk_sys::GtkTreeIter,
            data: glib_sys::gpointer,
        ) -> glib_sys::gboolean {
            let model = from_glib_borrow(model);
            let path = from_glib_borrow(path);
            let iter = from_glib_borrow(iter);
            let callback: *mut P = data as *const _ as usize as *mut P;
            let res = (*callback)(&model, &path, &iter);
            res.to_glib()
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            gtk_sys::gtk_tree_model_foreach(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    //fn get(&self, iter: &TreeIter, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) {
    //    unsafe { TODO: call gtk_sys:gtk_tree_model_get() }
    //}

    fn get_column_type(&self, index_: i32) -> glib::types::Type {
        unsafe {
            from_glib(gtk_sys::gtk_tree_model_get_column_type(
                self.as_ref().to_glib_none().0,
                index_,
            ))
        }
    }

    fn get_flags(&self) -> TreeModelFlags {
        unsafe {
            from_glib(gtk_sys::gtk_tree_model_get_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_iter(&self, path: &TreePath) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_get_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mut_override(path.to_glib_none().0),
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn get_iter_first(&self) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_get_iter_first(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn get_iter_from_string(&self, path_string: &str) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_get_iter_from_string(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                path_string.to_glib_none().0,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn get_n_columns(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_model_get_n_columns(self.as_ref().to_glib_none().0) }
    }

    fn get_path(&self, iter: &TreeIter) -> Option<TreePath> {
        unsafe {
            from_glib_full(gtk_sys::gtk_tree_model_get_path(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            ))
        }
    }

    fn get_string_from_iter(&self, iter: &TreeIter) -> Option<GString> {
        unsafe {
            from_glib_full(gtk_sys::gtk_tree_model_get_string_from_iter(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            ))
        }
    }

    //fn get_valist(&self, iter: &TreeIter, var_args: /*Unknown conversion*//*Unimplemented*/Unsupported) {
    //    unsafe { TODO: call gtk_sys:gtk_tree_model_get_valist() }
    //}

    fn get_value(&self, iter: &TreeIter, column: i32) -> glib::Value {
        unsafe {
            let mut value = glib::Value::uninitialized();
            gtk_sys::gtk_tree_model_get_value(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
                column,
                value.to_glib_none_mut().0,
            );
            value
        }
    }

    fn iter_children(&self, parent: Option<&TreeIter>) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_iter_children(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mut_override(parent.to_glib_none().0),
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_has_child(&self, iter: &TreeIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_model_iter_has_child(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            ))
        }
    }

    fn iter_n_children(&self, iter: Option<&TreeIter>) -> i32 {
        unsafe {
            gtk_sys::gtk_tree_model_iter_n_children(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            )
        }
    }

    fn iter_next(&self, iter: &TreeIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_model_iter_next(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            ))
        }
    }

    fn iter_nth_child(&self, parent: Option<&TreeIter>, n: i32) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_iter_nth_child(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mut_override(parent.to_glib_none().0),
                n,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_parent(&self, child: &TreeIter) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_model_iter_parent(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mut_override(child.to_glib_none().0),
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn iter_previous(&self, iter: &TreeIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_model_iter_previous(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            ))
        }
    }

    fn row_changed(&self, path: &TreePath, iter: &TreeIter) {
        unsafe {
            gtk_sys::gtk_tree_model_row_changed(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                mut_override(iter.to_glib_none().0),
            );
        }
    }

    fn row_deleted(&self, path: &TreePath) {
        unsafe {
            gtk_sys::gtk_tree_model_row_deleted(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    fn row_has_child_toggled(&self, path: &TreePath, iter: &TreeIter) {
        unsafe {
            gtk_sys::gtk_tree_model_row_has_child_toggled(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                mut_override(iter.to_glib_none().0),
            );
        }
    }

    fn row_inserted(&self, path: &TreePath, iter: &TreeIter) {
        unsafe {
            gtk_sys::gtk_tree_model_row_inserted(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                mut_override(iter.to_glib_none().0),
            );
        }
    }

    fn rows_reordered_with_length(
        &self,
        path: &TreePath,
        iter: Option<&TreeIter>,
        new_order: &[i32],
    ) {
        let length = new_order.len() as i32;
        unsafe {
            gtk_sys::gtk_tree_model_rows_reordered_with_length(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                mut_override(iter.to_glib_none().0),
                new_order.to_glib_none().0,
                length,
            );
        }
    }

    fn sort_new_with_model(&self) -> Option<TreeModel> {
        unsafe {
            from_glib_full(gtk_sys::gtk_tree_model_sort_new_with_model(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn connect_row_changed<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_changed_trampoline<P, F: Fn(&P, &TreePath, &TreeIter) + 'static>(
            this: *mut gtk_sys::GtkTreeModel,
            path: *mut gtk_sys::GtkTreePath,
            iter: *mut gtk_sys::GtkTreeIter,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeModel>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TreeModel::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(path),
                &from_glib_borrow(iter),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-changed\0".as_ptr() as *const _,
                Some(transmute(row_changed_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_row_deleted<F: Fn(&Self, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn row_deleted_trampoline<P, F: Fn(&P, &TreePath) + 'static>(
            this: *mut gtk_sys::GtkTreeModel,
            path: *mut gtk_sys::GtkTreePath,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeModel>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TreeModel::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-deleted\0".as_ptr() as *const _,
                Some(transmute(row_deleted_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_row_has_child_toggled<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_has_child_toggled_trampoline<
            P,
            F: Fn(&P, &TreePath, &TreeIter) + 'static,
        >(
            this: *mut gtk_sys::GtkTreeModel,
            path: *mut gtk_sys::GtkTreePath,
            iter: *mut gtk_sys::GtkTreeIter,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeModel>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TreeModel::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(path),
                &from_glib_borrow(iter),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-has-child-toggled\0".as_ptr() as *const _,
                Some(transmute(
                    row_has_child_toggled_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_row_inserted<F: Fn(&Self, &TreePath, &TreeIter) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_inserted_trampoline<P, F: Fn(&P, &TreePath, &TreeIter) + 'static>(
            this: *mut gtk_sys::GtkTreeModel,
            path: *mut gtk_sys::GtkTreePath,
            iter: *mut gtk_sys::GtkTreeIter,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeModel>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TreeModel::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(path),
                &from_glib_borrow(iter),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-inserted\0".as_ptr() as *const _,
                Some(transmute(row_inserted_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_rows_reordered<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Unimplemented new_order: *.Pointer
    //}
}

impl fmt::Display for TreeModel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TreeModel")
    }
}
