% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runMDS.R
\name{calculateMDS}
\alias{calculateMDS}
\alias{runMDS}
\alias{calculateMDS,ANY-method}
\alias{calculateMDS,SummarizedExperiment-method}
\alias{calculateMDS,SingleCellExperiment-method}
\title{Perform MDS on cell-level data}
\usage{
calculateMDS(x, ...)

\S4method{calculateMDS}{ANY}(
  x,
  FUN = dist,
  ncomponents = 2,
  ntop = 500,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  keep_dist = FALSE,
  ...
)

\S4method{calculateMDS}{SummarizedExperiment}(x, ..., exprs_values = "logcounts")

\S4method{calculateMDS}{SingleCellExperiment}(
  x,
  ...,
  exprs_values = "logcounts",
  dimred = NULL,
  n_dimred = NULL
)

runMDS(x, ..., altexp = NULL, name = "MDS")
}
\arguments{
\item{x}{For \code{calculateMDS}, a numeric matrix of log-expression values
where rows are features and columns are cells.
Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such a matrix.

For \code{runMDS}, a \linkS4class{SingleCellExperiment} object.}

\item{...}{For the \code{calculateMDS} generic, additional arguments to pass 
to specific methods. For the SummarizedExperiment and SingleCellExperiment 
methods, additional arguments to pass to the ANY method.

For \code{runMDS}, additional arguments to pass to \code{calculateMDS}.}

\item{FUN}{A function that accepts a numeric matrix as its first argument,
where rows are samples and columns are features; and returns a distance 
structure such as that returned by \code{dist} or a full symmetric matrix 
containing the dissimilarities.}

\item{ncomponents}{Numeric scalar indicating the number of MDS?g dimensions
to obtain.}

\item{ntop}{Numeric scalar specifying the number of features with the highest variances to use for dimensionality reduction.}

\item{subset_row}{Vector specifying the subset of features to use for dimensionality reduction.
This can be a character vector of row names, an integer vector of row indices or a logical vector.}

\item{scale}{Logical scalar, should the expression values be standardized?}

\item{transposed}{Logical scalar, is \code{x} transposed with cells in rows?}

\item{keep_dist}{Logical scalar indicating whether the \code{dist} object 
calculated by \code{FUN} should be stored as \sQuote{dist} attribute of the 
matrix returned/stored by \code{calculateMDS} or \code{runMDS}.}

\item{exprs_values}{Integer scalar or string indicating which assay of \code{x} contains the expression values.}

\item{dimred}{String or integer scalar specifying the existing dimensionality reduction results to use.}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use if \code{dimred} is specified.}

\item{altexp}{String or integer scalar specifying an alternative experiment containing the input data.}

\item{name}{String specifying the name to be used to store the result in the \code{\link{reducedDims}} of the output.}
}
\value{
For \code{calculateMDS}, a matrix is returned containing the MDS coordinates
for each cell (row) and dimension (column).

For \code{runMDS}, a modified \code{x} is returned that contains the MDS 
coordinates in \code{\link{reducedDim}(x, name)}.
}
\description{
Perform multi-dimensional scaling (MDS) on cells, based on the data in a SingleCellExperiment object.
}
\details{
The function \code{\link{cmdscale}} is used internally to compute the MDS 
components with \code{eig = TRUE}.
The \code{eig} and \code{GOF} fields of the object returned by 
\code{\link{cmdscale}} are stored as attributes \dQuote{eig} and \dQuote{GOF}
of the MDS matrix calculated.
}
\section{Feature selection}{

This section is relevant if \code{x} is a numeric matrix of (log-)expression values with features in rows and cells in columns;
or if \code{x} is a \linkS4class{SingleCellExperiment} and \code{dimred=NULL}.
In the latter, the expression values are obtained from the assay specified by \code{exprs_values}.

The \code{subset_row} argument specifies the features to use for dimensionality reduction.
The aim is to allow users to specify highly variable features to improve the signal/noise ratio,
or to specify genes in a pathway of interest to focus on particular aspects of heterogeneity.

If \code{subset_row=NULL}, the \code{ntop} features with the largest variances are used instead.
We literally compute the variances from the expression values without considering any mean-variance trend,
so often a more considered choice of genes is possible, e.g., with \pkg{scran} functions.
Note that the value of \code{ntop} is ignored if \code{subset_row} is specified.

If \code{scale=TRUE}, the expression values for each feature are standardized so that their variance is unity.
This will also remove features with standard deviations below 1e-8.
}

\section{Using reduced dimensions}{

If \code{x} is a \linkS4class{SingleCellExperiment}, the method can be applied on existing dimensionality reduction results in \code{x} by setting the \code{dimred} argument.
This is typically used to run slower non-linear algorithms (t-SNE, UMAP) on the results of fast linear decompositions (PCA).
We might also use this with existing reduced dimensions computed from \emph{a priori} knowledge (e.g., gene set scores), where further dimensionality reduction could be applied to compress the data.

The matrix of existing reduced dimensions is taken from \code{\link{reducedDim}(x, dimred)}.
By default, all dimensions are used to compute the second set of reduced dimensions.
If \code{n_dimred} is also specified, only the first \code{n_dimred} columns are used.
Alternatively, \code{n_dimred} can be an integer vector specifying the column indices of the dimensions to use.

When \code{dimred} is specified, no additional feature selection or standardization is performed.
This means that any settings of \code{ntop}, \code{subset_row} and \code{scale} are ignored.

If \code{x} is a numeric matrix, setting \code{transposed=TRUE} will treat the rows as cells and the columns as the variables/diemnsions.
This allows users to manually pass in dimensionality reduction results without needing to wrap them in a \linkS4class{SingleCellExperiment}.
As such, no feature selection or standardization is performed, i.e., \code{ntop}, \code{subset_row} and \code{scale} are ignored.
}

\section{Using alternative Experiments}{

This section is relevant if \code{x} is a \linkS4class{SingleCellExperiment} and \code{altexp} is not \code{NULL}.
In such cases, the method is run on data from an alternative \linkS4class{SummarizedExperiment} nested within \code{x}.
This is useful for performing dimensionality reduction on other features stored in \code{\link{altExp}(x, altexp)}, e.g., antibody tags. 

Setting \code{altexp} with \code{exprs_values} will use the specified assay from the alternative SummarizedExperiment.
If the alternative is a SingleCellExperiment, setting \code{dimred} will use the specified dimensionality reduction results from the alternative. 
This option will also interact as expected with \code{n_dimred}.

Note that the output is still stored in the \code{\link{reducedDims}} of the output SingleCellExperiment.
It is advisable to use a different \code{name} to distinguish this output from the results generated from the main experiment's assay values.
}

\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

example_sce <- runMDS(example_sce)
reducedDimNames(example_sce)
head(reducedDim(example_sce))
}
\seealso{
\code{\link{cmdscale}}, to perform the underlying calculations.

\code{\link{dist}} for the function used as default to calculate the 
\code{dist} object.

\code{\link[scater]{plotMDS}}, to quickly visualize the results.
}
\author{
Aaron Lun, based on code by Davis McCarthy
}
