% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duprateExpDensPlot.R
\name{duprateExpDensPlot}
\alias{duprateExpDensPlot}
\title{Duplication rate ~ total read count plot}
\usage{
duprateExpDensPlot(
  DupMat,
  pal = c("cyan", "blue", "green", "yellow", "red"),
  tNoAlternative = TRUE,
  tRPKM = TRUE,
  tRPKMval = 0.5,
  tFit = TRUE,
  addLegend = TRUE,
  ...
)
}
\arguments{
\item{DupMat}{The duplication matrix calculated by \code{analyzeDuprates}}

\item{pal}{The color palette to use to display the density}

\item{tNoAlternative}{Display threshold of 1000 reads per kilobase}

\item{tRPKM}{Display threshold at a given RPKM level}

\item{tRPKMval}{The given RPKM level}

\item{tFit}{Whether to fit the model}

\item{addLegend}{Whether to add a legend to the plot}

\item{...}{Other parameters sent to plot()}
}
\value{
nothing
}
\description{
\code{duprateExpDensPlot} Duplication rate ~ total read count plot
}
\details{
This function makes a scatter plot showing the per gene duplication rate
versus the total read count.
}
\examples{
# dm is a duplication matrix calculated by analyzeDuprates:
# R> dm <- analyzeDuprates(bamDuprm,gtf,stranded,paired,threads)
attach(dupRadar_examples)

# duprate plot
duprateExpDensPlot(DupMat=dm)
}
