# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class PlaybackGrantList(ListResource):

    def __init__(self, version, sid):
        """
        Initialize the PlaybackGrantList

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantList
        """
        super(PlaybackGrantList, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }

    def get(self):
        """
        Constructs a PlaybackGrantContext

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        """
        return PlaybackGrantContext(self._version, sid=self._solution['sid'], )

    def __call__(self):
        """
        Constructs a PlaybackGrantContext

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        """
        return PlaybackGrantContext(self._version, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Media.V1.PlaybackGrantList>'


class PlaybackGrantPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the PlaybackGrantPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param sid: The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantPage
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantPage
        """
        super(PlaybackGrantPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of PlaybackGrantInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        return PlaybackGrantInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Media.V1.PlaybackGrantPage>'


class PlaybackGrantContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the PlaybackGrantContext

        :param Version version: Version that contains the resource
        :param sid: The SID that identifies the resource to fetch

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        """
        super(PlaybackGrantContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/PlayerStreamers/{sid}/PlaybackGrant'.format(**self._solution)

    def create(self, ttl=values.unset, access_control_allow_origin=values.unset):
        """
        Create the PlaybackGrantInstance

        :param unicode ttl: The time to live of the PlaybackGrant
        :param unicode access_control_allow_origin: The full URL that is authorized to play back the livestream

        :returns: The created PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        data = values.of({'Ttl': ttl, 'AccessControlAllowOrigin': access_control_allow_origin, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return PlaybackGrantInstance(self._version, payload, sid=self._solution['sid'], )

    def fetch(self):
        """
        Fetch the PlaybackGrantInstance

        :returns: The fetched PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return PlaybackGrantInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Media.V1.PlaybackGrantContext {}>'.format(context)


class PlaybackGrantInstance(InstanceResource):

    def __init__(self, version, payload, sid):
        """
        Initialize the PlaybackGrantInstance

        :returns: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        super(PlaybackGrantInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'url': payload.get('url'),
            'account_sid': payload.get('account_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'grant': payload.get('grant'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: PlaybackGrantContext for this PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantContext
        """
        if self._context is None:
            self._context = PlaybackGrantContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def grant(self):
        """
        :returns: The grant that authorizes the player sdk to connect to the livestream
        :rtype: dict
        """
        return self._properties['grant']

    def create(self, ttl=values.unset, access_control_allow_origin=values.unset):
        """
        Create the PlaybackGrantInstance

        :param unicode ttl: The time to live of the PlaybackGrant
        :param unicode access_control_allow_origin: The full URL that is authorized to play back the livestream

        :returns: The created PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        return self._proxy.create(ttl=ttl, access_control_allow_origin=access_control_allow_origin, )

    def fetch(self):
        """
        Fetch the PlaybackGrantInstance

        :returns: The fetched PlaybackGrantInstance
        :rtype: twilio.rest.media.v1.player_streamer.playback_grant.PlaybackGrantInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Media.V1.PlaybackGrantInstance {}>'.format(context)
