#!/usr/bin/env bash
#
# Copyright 2019-2020, Intel Corporation
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in
#       the documentation and/or other materials provided with the
#       distribution.
#
#     * Neither the name of the copyright holder nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# run-build.sh <pmemkv_version> - checks binding's building and installation
#                                 with pmemkv installed in given version
#

set -e

# build and install pmemkv
pmemkv_version=$1
cd /opt/pmemkv-$pmemkv_version/

if [ "${PACKAGE_MANAGER}" = "deb" ]; then
	echo $USERPASS | sudo -S dpkg -i libpmemkv*.deb
elif [ "${PACKAGE_MANAGER}" = "rpm" ]; then
	echo $USERPASS | sudo -S rpm -i libpmemkv*.rpm
else
	echo "PACKAGE_MANAGER env variable not set or set improperly ('deb' or 'rpm' supported)."
	exit 1
fi

echo
echo "##########################################################"
echo "### Verifying building, installation and tests execution  "
echo "##########################################################"
cd $WORKDIR
python3 setup.py bdist_wheel
pip3 install dist/pmemkv-*.whl --user
cd $WORKDIR/tests
python3 -X faulthandler -m pytest -v pmemkv_tests.py
python3 -X faulthandler -m pytest -v  nontrivial_data_tests.py

echo
echo "##########################################################"
echo "### Checking examples"
echo "##########################################################"
cd $WORKDIR/examples
PMEM_IS_PMEM_FORCE=1 python3 basic_example.py

REST_API_EXAMPLE_DIR="${WORKDIR}/examples/restAPI"
python3 ${REST_API_EXAMPLE_DIR}/run_example.py

echo
echo "########################################################"
echo "### Generating doc"
echo "########################################################"
cd $WORKDIR/doc
make html
