if (typeof T === 'undefined') require('../setup');

T('atan', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).atan().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('0', 40, 4, '0');
  t('-0', 40, 4, '-0');
  t('Infinity', 20, 4, '1.5707963267948966192');
  t('-Infinity', 20, 4, '-1.5707963267948966192');

  t('0.454786854', 2, 1, '0.42');
  t('392.8825877961099786091', 2, 1, '1.5');
  t('90.02', 9, 1, '1.55968814');
  t('0.22618819', 1, 6, '0.2');
  t('2.104', 3, 3, '1.12');
  t('0.4', 2, 0, '0.39');
  t('700000', 7, 5, '1.570795');
  t('0.1034373855738', 4, 0, '0.1031');
  t('2888822222222222.77777777888888888887945111', 4, 2, '1.571');
  t('0.7163035', 5, 0, '0.62159');
  t('31986483109634719887104428745', 4, 1, '1.57');
  t('66099.99999090960999899', 9, 2, '1.5707812');
  t('1453.5793000200494316368218639720487955117970374751', 8, 3, '1.5701083');
  t('25', 10, 1, '1.530817639');
  t('0.00083', 2, 5, '0.00083');
  t('15469795946533333333333', 3, 2, '1.58');
  t('0.0471789911257911619518474101710506908660018025802862437747', 10, 4, '0.04714403323');
  t('2436496471267622480734244943816819264461333', 6, 4, '1.5708');
  t('397.86', 6, 3, '1.56828');
  t('23350774.374402222222222222', 5, 2, '1.5708');
  t('6.4999999895999999999999989901', 3, 2, '1.42');
  t('0.2021040932658758909350221378184270710381308788971', 25, 0, '0.1994179053851243775408929');
  t('37322947047433501470414286593213511', 3, 4, '1.57');
  t('0.2', 30, 5, '0.197395559849880758370049765195');
  t('68205', 73, 0, '1.570781665113202779409754819994955472047433041976705657000777636779446534');
  t('546276727353824444.00000000000000000004444444444444444', 10, 1, '1.570796326');
  t('0.702767582631380812', 59, 3, '0.6125809883518849916298401561171422315736485425008362936336');
  t('77.2782608490479012', 63, 5, '1.55785679919770947051742907742015525136935668142627146470943833');
  t('3782579384288161800008711705384065591', 64, 1, '1.570796326794896619231321691639751441834214834998463624232552952');
  t('353878', 38, 3, '1.5707935009622650418565673617028447836');
  t('474922903013', 37, 0, '1.570796326792791014313858641566394633');
  t('0.983379312948256841133252743255261706498115379968780272468295525', 33, 3, '0.777018375475969147205287424713916');
  t('0.94045376770729661028346135758732992772225497003464820039412612634023416', 56, 1, '0.75472103378449515948583375795023656690367842174996205064');
  t('8343887380309832830517659566088111111111111111111.111', 62, 0, '1.570796326794896619231321691639751442098584699687433062273514');
  t('0.0228839501439921', 54, 5, '0.0228799568131160143605040060800166535189129302340883479');
  t('99999920979720113000000.551327043', 30, 2, '1.57079632679489661923131169164');
  t('8203149', 25, 4, '1.570796204890491371929944');
  t('930000000504000000000000000000000.0870000004', 43, 1, '1.570796326794896619231321691639750366829768');
  t('50000000000', 16, 4, '1.570796326774897');
  t('2675303931293671338171189092726796196.369350899273657748425', 9, 3, '1.57079632');
  t('98351.2797372595375675252656040297344674063', 52, 5, '1.570786159159024091806382088738657135356199886480858');
  t('9291816239901918141826076554839014635448673990956049062', 55, 4, '1.57079632679489661923132169163975144209858469968755291');
  t('6', 72, 6, '1.40564764938026978095219340199580798810019803922252509146943786614276254');
  t('2366378489504444444444.33333333333488', 12, 0, '1.5707963268');
  t('161100000000000000000000.5111111', 42, 0, '1.57079632679489661923131548431510836326557');

  /*
  t('4255555555555555555555555555555555555555555555555555.555553575553555556', 4, 0, '1.571');
  t('8', 5, 5, '1.4464');
  t('0.00000005243', 4, 2, '0.00000005243');
  t('90000000000000000000918942', 2, 5, '1.6');
  t('66060423.9514610923717025329', 2, 4, '1.6');
  t('6721603208.37153733325342504174531056831', 9, 3, '1.57079632');
  t('0.37534', 7, 3, '0.3590687');
  t('211111111111111111111.11111111111111111111111111114111111111114111111111111211117111411131111111', 5, 4, '1.5708');
  t('0.0000000033863978398551079571001448971465337832890474132632478399246', 6, 4, '0.0000000033864');
  t('3185000', 4, 6, '1.571');
  t('999999929999999999999599.999999999999999', 2, 1, '1.5');
  t('44859239063215', 2, 0, '1.6');
  t('8604639.371141156347736588894655375650797712452434364102701907458155331637989138659', 4, 5, '1.571');
  t('56966.475128', 4, 3, '1.57');
  t('60023179160012835406838457633089174491605855118688614415337956367995333333333333333', 1, 1, '1');
  t('81422.3', 5, 4, '1.5708');
  t('8468', 3, 1, '1.57');
  t('1309118155947', 5, 2, '1.5708');
  t('0.065', 7, 5, '0.06490869');
  t('0.5', 7, 0, '0.4636477');
  t('75273151108297026877107393281372', 5, 6, '1.5708');
  t('93949.07662040577', 10, 5, '1.570785683');
  t('0.0001667707', 10, 5, '0.0001667706985');
  t('0.97', 8, 5, '0.77017091');
  t('7.58888288881', 1, 3, '1');
  t('60000000', 8, 0, '1.5707964');
  t('0.78572996832', 5, 4, '0.66598');
  t('44119576558941207147519327281846199061', 5, 1, '1.5707');
  t('0.0000008837845876464810734172', 4, 1, '0.0000008837');
  t('0.0004', 9, 4, '0.000399999979');
  t('0.2323330540805621821118353480956466729421142235', 8, 2, '0.2282831');
  t('79999999999999926366666666666666666666', 1, 6, '2');
  t('0.95', 9, 3, '0.759762754');
  t('656257207', 7, 2, '1.570797');
  t('0.00161360752405294429603675177995387769065133534837330691193598117674132388151448244062544389', 8, 5, '0.0016136061');
  t('74828342902847955856666782218011827398846431511213763886945014448538', 10, 5, '1.570796327');
  t('379919117.1110111141111411112', 5, 5, '1.5708');
  t('16000000', 7, 1, '1.570796');
  t('5210000.0000070002000000000000000004000000000000000000003', 3, 3, '1.57');
  t('0.70237', 4, 5, '0.6123');
  t('0.2', 3, 6, '0.197');
  t('2.433', 6, 2, '1.18084');
  t('0.674', 5, 6, '0.59306');
  t('0.16864431678', 2, 2, '0.17');
  t('99310562.987102686', 4, 5, '1.571');
  t('57343470572.5577748200322614', 11, 0, '1.5707963268');
  t('9', 3, 5, '1.46');
  t('9', 9, 4, '1.46013911');
  t('68', 6, 5, '1.55609');
  t('45045544594890', 4, 3, '1.57');
  t('2', 6, 6, '1.10715');
  t('4087000000', 8, 0, '1.5707964');
  t('2419774648.633530428', 6, 3, '1.57079');
  t('963794433119055555555555.393374993572327193537378798999513412199999999999999', 1, 5, '2');
  t('0.000000337', 2, 5, '0.00000034');
  t('16', 2, 1, '1.5');
  t('0.21', 7, 1, '0.2069921');
  t('0.35', 9, 0, '0.33667482');
  t('86666666622.777777666621431962', 7, 1, '1.570796');
  t('0.1', 7, 0, '0.09966866');
  t('53337', 6, 1, '1.57077');
  t('100000000000031251284', 10, 5, '1.570796327');
  t('29919414446671153', 3, 1, '1.57');
  t('1', 4, 1, '0.7853');
  t('0.0000042', 3, 1, '0.00000419');
  t('8', 7, 5, '1.446441');
  t('4', 6, 2, '1.32582');
  t('0.519744021377950190285330709596862552528393098130790899666073', 5, 6, '0.47932');
  t('0.1443', 1, 6, '0.1');
  t('5.6544', 9, 3, '1.39575287');
  t('0.701519', 3, 5, '0.612');
  t('8', 7, 5, '1.446441');
  t('4150827480.853907974387739203156', 2, 1, '1.5');
  t('0.37', 9, 0, '0.35437992');
  t('817600', 6, 0, '1.5708');
  t('6847.361', 8, 6, '1.5706503');
  t('67206693345838991031403.756160484167896', 2, 0, '1.6');
  t('33', 10, 2, '1.540502567');
  t('1120.7777777777777773304', 5, 5, '1.5699');
  t('0.41589804', 6, 5, '0.394136');
  t('444666404791634168967916041841994.702195285086546889393', 7, 0, '1.570797');
  t('400000', 7, 4, '1.570794');
  t('20000000', 8, 1, '1.5707962');
  t('209.8888888888888844515', 7, 5, '1.566032');
  t('0.852407143590463345522983396762436350231', 8, 1, '0.70588987');
  t('0.000051866', 10, 2, '0.00005186599996');
  t('2521', 5, 1, '1.5703');
  t('78024.8733', 5, 3, '1.5707');
  t('58.169', 10, 4, '1.553606733');
  t('359999999999999999999099299999499999999999998.9999990999999999999999999', 8, 0, '1.5707964');
  t('18054455', 5, 2, '1.5708');
  t('15.755', 3, 1, '1.5');
  t('460', 2, 6, '1.6');
  t('0.0188207120631385279750954085704950583960475', 9, 5, '0.0188184903');
  t('9.1969946', 10, 1, '1.462490631');
  t('93333.333333333176379', 8, 0, '1.5707857');
  t('0.600266036086902813107358186588490770503589187680400080438781', 2, 2, '0.55');
  t('9380000006000000000002000000000000000000000000000000000000000000000000000000004', 10, 3, '1.570796326');
  t('0.00575751780715113427164995', 10, 2, '0.00575745419');
  t('690008800500000.009', 5, 5, '1.5708');
  t('0.7', 9, 4, '0.610725964');
  t('53724', 7, 1, '1.570777');
  t('7667270546223.4448429904767251543698631073291445742', 3, 0, '1.58');
  t('749866622.666666', 10, 1, '1.570796325');
  t('9464211111111126111111111111111111111121111111.71111111111111', 10, 3, '1.570796326');
  t('0.6', 5, 5, '0.54042');
  t('0.57696014724929', 8, 1, '0.52330613');
  t('0.3303', 2, 4, '0.32');
  t('0.9', 8, 1, '0.7328151');
  t('0.8', 2, 6, '0.67');
  t('4896403.619161228080605974859347', 7, 1, '1.570796');
  t('198517391139695696290029000775071962279035770517', 9, 2, '1.57079633');
  t('5157701362915334840560595834324794949461903071633390241902821611993841502732450673987304052309', 3, 3, '1.57');
  t('0.43', 3, 1, '0.406');
  t('8666666757743988507652058211333333.33333', 7, 4, '1.570796');
  t('0.842499', 2, 1, '0.7');
  t('122.2', 3, 3, '1.56');
  t('593', 10, 4, '1.569109988');
  t('0.8818', 1, 3, '0.7');
  t('21', 6, 3, '1.52321');
  t('86293305751.3230619267808428731392308627628801001', 4, 1, '1.57');
  t('16804583510684186963.018502854487444', 1, 0, '2');
  t('0.0001', 8, 0, '0.0001');
  t('4242909933445476325611738806174236096544.908714630729526395782', 6, 0, '1.5708');
  t('1', 5, 1, '0.78539');
  t('0.007', 6, 0, '0.00699989');
  t('8', 3, 4, '1.45');
  t('70', 4, 3, '1.556');
  t('3425', 1, 3, '1');
  t('451', 5, 4, '1.5686');
  t('8141.31623683639667706', 4, 5, '1.571');
  t('0.000615774263363824407', 6, 1, '0.000615774');
  t('11170613', 1, 6, '2');
  t('0.000000067404745897820652084701644321259298841', 6, 0, '0.0000000674048');
  t('33990000000009090005000000000000000006000000000000000', 10, 3, '1.570796326');
  t('9', 7, 2, '1.46014');
  t('9.333', 9, 2, '1.46405688');
  t('9000000000.00000030000600000000000000000003', 5, 4, '1.5708');
  t('9337141919830471903724685292141789497273573.658099072577685037687145756128496922356740940795', 3, 2, '1.58');
  t('0.000045', 6, 5, '0.000045');
  t('0.4', 1, 0, '0.4');
  t('0.444756015', 8, 2, '0.41848448');
  t('5575161748.7539120330584429031317046967', 5, 6, '1.5708');
  t('46.4', 1, 3, '1');
  t('0.203426889', 1, 0, '0.3');
  t('0.054', 19, 5, '0.05394760364216254932');
  t('353959.38', 2, 0, '1.6');
  t('74169374334036876444230795143300166331863765379', 7, 6, '1.570796');
  t('15.19018', 18, 4, '1.50505917771202372');
  t('3326343666', 20, 5, '1.5707963264942662273');
  t('0.0000000071251162', 1, 3, '0.000000007');
  t('2.0009', 5, 4, '1.1073');
  t('6705015260743742395517681395631.46667952563136285936331702269434439032', 10, 0, '1.570796327');
  t('6', 7, 5, '1.405648');
  t('3111126235.30263', 13, 5, '1.570796326473');
  t('0.1524730666719', 15, 2, '0.151307712850436');
  t('3786.713', 7, 6, '1.570532');
  t('0.192', 16, 6, '0.1896915520223806');
  t('74.4125712213259562429633', 15, 3, '1.55735854616794');
  t('5', 15, 1, '1.37340076694501');
  t('2222222522.22222222223', 1, 4, '2');
  t('43104182.40314', 20, 4, '1.5707963035952917492');
  t('7.11111111', 10, 2, '1.431087453');
  t('8275133', 13, 1, '1.57079620595');
  t('1275920480.8656217776062214388199788136', 9, 4, '1.57079633');
  t('0.807526', 7, 5, '0.6793131');
  t('0.860572717616630645228638882', 14, 0, '0.71060013802643');
  t('9.149830551043357', 1, 2, '2');
  t('699999999999.999999', 10, 3, '1.570796326');
  t('0.00049425612369342263152648633348687979871091472683831861', 11, 1, '0.00049425608344');
  t('0.6964950764232450078224720303827', 12, 1, '0.608369791345');
  t('0.97174510300524447126897418693399323494589950399453756485887175037390442', 4, 1, '0.771');
  t('755555555555555555055855555555.55555554552555555555555555555', 3, 5, '1.57');
  t('185231', 17, 3, '1.5707909281305262');
  t('69.4', 14, 4, '1.5563881020101');
  t('0.8724516608', 15, 2, '0.71738486842166');
  t('0.9', 6, 2, '0.732816');
  t('86572907665698262226085', 10, 5, '1.570796327');
  t('0.9822428384084134678015218524008167259563354101144964976542345139331139722995296579', 8, 5, '0.77644029');
  t('3288888888858888688.88888488888888888808888888885888858808', 14, 0, '1.5707963267949');
  t('57000000', 18, 5, '1.57079630925103697');
  t('42051089116', 2, 4, '1.6');
  t('264354111.3', 8, 4, '1.5707963');
  t('0.849330692424884', 13, 2, '0.7041053683497');
  t('875083676372267739803385530062400304035782730200834882362610010', 13, 1, '1.570796326794');
  t('95710313.07535260894', 2, 2, '1.6');
  t('3000000000000000000000300000000000000000000000000000000000000000000', 4, 2, '1.571');
  t('73732622978.7007613723', 1, 3, '1');
  t('400000000000000009658105119780842448210290852', 9, 6, '1.57079633');
  t('20096.71757', 14, 0, '1.5707465674253');
  t('14099899.9', 3, 0, '1.58');
  t('96857222.073694270051398165030034606323', 19, 5, '1.570796316470421287');
  t('60944217', 9, 5, '1.57079631');
  t('0.000004332', 3, 1, '0.00000433');
  t('7452004.3', 11, 1, '1.5707961926');
  t('217750', 14, 2, '1.5707917343724');
  t('12377127827293998751802990547081366466027858274277877132', 16, 6, '1.570796326794897');
  t('69999999991822', 17, 6, '1.5707963267948823');
  t('42', 8, 1, '1.5469913');
  t('0.4917', 17, 5, '0.45698558932906678');
  t('0.101404775271136622070316250694364947429603', 12, 5, '0.101059324776');
  t('12222186510722151299553.9999942974103004353794665227029274549392636924664039397525444444444444444444', 16, 1, '1.570796326794896');
  t('36561', 6, 5, '1.57077');
  t('2201352.0879', 17, 4, '1.5707958725286275');
  t('306111.666666666666666666611111111111', 20, 1, '1.5707930600131666521');
  t('14.046', 3, 2, '1.5');
  t('41111118456096677777777777777.99999999918053266666666666666', 10, 3, '1.570796326');
  t('0.675635', 10, 4, '0.594185777');
  t('3111.82343046105988', 10, 3, '1.570474971');
  t('111111768691.64442', 19, 1, '1.570796326785896672');
  t('313666666661.266666566666666666666666666566866666666646666666666666666666666666666666666', 12, 1, '1.57079632679');
  t('75.58788', 10, 1, '1.557567464');
  t('6779165975.164558468370203', 20, 0, '1.5707963266473858482');
  t('90', 19, 3, '1.559685672897289146');
  t('0.45', 5, 2, '0.42286');
  t('784332.17', 12, 6, '1.57079505182');
  t('100000000000022222222222222222.222222222222200589938', 18, 0, '1.57079632679489662');
  t('0.9668', 15, 0, '0.768519554903472');
  t('37461083158886018839166119.2807028', 10, 2, '1.570796327');
  t('75', 1, 6, '2');
  t('0.16443191881562934710394179741877680589686339475689172238601', 5, 3, '0.16297');
  t('25.2', 7, 1, '1.531134');
  t('0.02604809', 10, 6, '0.02604220116');
  t('0.56066428940295', 13, 2, '0.5109938801367');
  t('6394863', 20, 0, '1.5707961704193808342');
  t('2565688213422047175566032462062819841946222', 11, 6, '1.5707963268');
  t('6684663.3', 3, 4, '1.57');
  t('0.6', 14, 3, '0.54041950027058');
  t('6945.38219777', 14, 5, '1.5706523462385');
  t('93000000', 1, 5, '2');
  t('4.04910163097337343687956687332048', 20, 1, '1.3286729984418555736');
  t('596586883219', 2, 1, '1.5');
  t('38.2', 17, 3, '1.5446242936936584');
  t('2092295.19', 16, 0, '1.570795848850865');
  t('80000000002000000000000000000000500000000000000000000000005000', 3, 4, '1.57');
  t('438', 13, 4, '1.568513225739');
  t('1397111111111111161111111110111111111113111111111111111611111111.111111111111111111119111111111', 7, 4, '1.570796');
  t('5944133333333333333', 19, 3, '1.570796326794896619');
  t('95260', 12, 1, '1.5707858292');
  t('54211.8623721087', 16, 6, '1.570777880647575');
  t('1', 4, 2, '0.7854');
  t('528437806.9575441115797782028770441878570921', 11, 3, '1.5707963249');
  t('0.5777339', 3, 2, '0.524');
  t('48139328000955628.943353141147592044553', 13, 6, '1.570796326795');
  t('5.988', 1, 5, '1');
  t('673073818773692580971.2862371537384', 19, 5, '1.570796326794896619');
  t('60000000000000', 9, 4, '1.57079633');
  t('615805142584367', 5, 3, '1.5707');
  t('43.06', 9, 3, '1.54757709');
  t('16666666666999999999999.222222222222222226675', 2, 4, '1.6');
  t('80700003.2', 11, 5, '1.5707963144');
  t('87954.6', 4, 4, '1.571');
  t('69.27', 11, 5, '1.5563610656');
  t('666666666666666666666.88833333333566666666666', 10, 3, '1.570796326');
  t('6618.683', 11, 1, '1.5706452393');
  t('49999999999999999999999999999993.99999999999999997', 14, 3, '1.5707963267948');
  t('2222222222222222222222222222222222222922222222222222222222222222222222222222.22222', 17, 6, '1.5707963267948966');
  t('1', 14, 6, '0.78539816339745');
  t('300462515077870245970491783520909662098219341140491', 1, 4, '2');
  t('0.1', 4, 2, '0.09967');
  t('8094446114.444444444444', 18, 5, '1.57079632667135512');
  t('1599999999999999999999999999999999999.9999999999999', 4, 6, '1.571');
  t('3509257563891435847738951559', 19, 6, '1.570796326794896619');
  t('57700000', 15, 0, '1.57079630946388');
  t('4178405459281466.995', 19, 4, '1.57079632679489638');
  t('705.6854234478059169', 7, 5, '1.569379');
  t('0.000000774663644739379172127283954522452089', 7, 5, '0.0000007746636');
  t('30502323249', 3, 0, '1.58');
  t('511111111111153333', 9, 0, '1.57079633');
  t('9111.111111', 5, 4, '1.5707');
  t('591.48', 4, 1, '1.569');
  t('43956701', 3, 4, '1.57');
  t('0.114919', 4, 4, '0.1144');
  t('725993522234858314329635181614713581804274369182923471127636306600299', 9, 0, '1.57079633');
  t('242704839614944612944', 13, 1, '1.570796326794');
  t('59', 3, 1, '1.55');
  t('2.97', 20, 0, '1.2460185364387823301');
  t('4.427211956', 17, 4, '1.3486484510096502');
  t('2759952973', 7, 1, '1.570796');
  t('22117028.66666666666184479481', 12, 5, '1.57079628158');
  t('0.8656674915', 7, 1, '0.7135198');
  t('58630.2894221', 12, 4, '1.57077927076');
  t('830831657411348596687376450704481.133530062303489966405161', 1, 4, '2');
  t('2400000.55555554863321111111111111111111', 1, 5, '2');
  t('731663462.38676', 12, 3, '1.57079632542');
  t('8225222222222222222221222222229222222222222222222222222024222222222222222220222222222.222222222222', 12, 3, '1.57079632679');
  t('8', 15, 5, '1.44644133224814');
  t('179999.7999', 17, 3, '1.5707907712331651');
  t('20720990509478660194603324228625133278', 5, 3, '1.5707');
  t('35820', 8, 6, '1.5707684');
  t('31164599280813727153843868483140', 2, 6, '1.6');
  t('7.96', 1, 4, '1');
  t('377888835886', 16, 0, '1.570796326792251');
  t('0.996691693688702478', 6, 6, '0.783741');
  t('0.0000000015164291', 12, 1, '0.00000000151642909999');
  t('9901300.000638149084', 13, 2, '1.570796225799');
  t('8839571581863523354341987103224763661451795705696151701620364', 5, 2, '1.5708');
  t('41.76950003000000009', 4, 0, '1.547');
  t('1846388289522.893727540438082386472982349042', 9, 2, '1.57079633');
  t('4', 7, 1, '1.325817');
  t('3.1', 17, 0, '1.2587542052323634');
  t('755556631999999999', 14, 1, '1.5707963267948');
  t('4999999999999999963469567', 7, 3, '1.570796');
  t('353382644077473210274662', 14, 4, '1.5707963267949');
  t('40000', 3, 2, '1.58');
  t('468.4122', 18, 6, '1.56866145823088766');
  t('2777777777777677777777777778773777.77777770777777777777777777777', 8, 5, '1.5707963');
  t('8662161220043381321017020984012066833249242570554112625706350710541492160', 15, 4, '1.5707963267949');
  t('3595669.6', 6, 5, '1.5708');
  t('91578.46381366254408705141634392', 14, 0, '1.5707854071971');
  t('705488.8888888888888888887888888888188888818888288084', 12, 6, '1.57079490934');
  t('4444444444444444444447444444444444.4444', 14, 5, '1.5707963267949');
  t('91111.111111111611115', 16, 0, '1.570785351185141');
  t('9709544893794.802575382489802332', 4, 5, '1.571');
  t('0.93980064136400456512422864327708459152987', 27, 6, '0.754374334147010659089244184');
  t('0.79', 25, 6, '0.6686135679278209106919582');
  t('68.94444464444144441404', 27, 6, '1.55629291193926841573948013');
  t('0.58575408097', 32, 5, '0.52987869920365187730504311568444');
  t('0.20916', 17, 6, '0.20618753780750517');
  t('499999999996126998', 6, 5, '1.5708');
  t('60.2', 7, 1, '1.554186');
  t('91111111111111111.222221681', 28, 4, '1.570796326794896608255711936');
  t('0.434022070205160079407451089414549594669951329971452908479909513133795938222879820644625974', 25, 3, '0.4094875365294782316357052');
  t('2.26', 9, 2, '1.15421539');
  t('888', 5, 2, '1.5697');
  t('0.588442379933', 17, 5, '0.53187790372259856');
  t('2', 28, 1, '1.10714871779409050301706546');
  t('0.5408360268324', 3, 0, '0.496');
  t('8383436696040469273622430840837817479317216788', 1, 3, '1');
  t('0.87129019999919999999999999909299', 28, 5, '0.7167250070636630655784453667');
  t('5802794017.1023945272212946204997680069051815419864202758516548351721495', 6, 2, '1.5708');
  t('74469964543133721462406880638127787302', 30, 5, '1.57079632679489661923132169164');
  t('23199089.783468302215866', 3, 4, '1.57');
  t('0.8', 14, 4, '0.67474094222355');
  t('0.3466909730436502', 33, 2, '0.333723875052398278485715593455697');
  t('0.02744306336722998106064665171541567451766495848106476381009574229124724', 23, 3, '0.027436177156229766741523');
  t('40000000000000747900283309094900', 24, 5, '1.57079632679489661923132');
  t('0.3582011007420322104418281989906222', 33, 3, '0.343962158448546289632284121172668');
  t('0.6385665545', 39, 1, '0.568295612683459397449054651413593229974');
  t('4.3385', 38, 4, '1.3442584192995616297335319105160047149');
  t('8008007602809987779715512385930375838312524243523474003888', 26, 5, '1.5707963267948966192313217');
  t('960000000000000000000005000000000000000000600000000000000000400000008000040000000000000000000000', 33, 4, '1.57079632679489661923132169163975');
  t('0.706178753', 3, 3, '0.614');
  t('3444444444444444444.41383807531693867118189834712300228087425425', 31, 4, '1.570796326794896618940999110995');
  t('988888888888888888641029432482165131736890000000.2222222222222222222865750311', 3, 5, '1.57');
  t('0.2842265', 39, 5, '0.276923619089587922029502604248364811669');
  t('2.8389389283587594', 31, 1, '1.232123549234702277485074565368');
  t('0.0000010560989', 3, 5, '0.00000106');
  t('578977888752762', 21, 5, '1.57079632679489489205');
  t('8.899999994', 39, 1, '1.45890606054841686389214855673930705412');
  t('0.00005321856206842641313', 30, 0, '0.0000532185620181842704412891368122');
  t('0.92', 39, 0, '0.743755584298859885755482781119123508102');
  t('8222222222622772887509160150844444444444.33336666666666', 4, 4, '1.571');
  t('0.16220214580070668009549992', 2, 6, '0.16');
  t('989603417.6', 34, 0, '1.570796325784390812344342727694401');
  t('0.17386338', 35, 2, '0.17214260865094965353014938821154837');
  t('0.0011908', 17, 2, '0.0011907994371471705');
  t('10977777', 20, 0, '1.5707962357017727564');
  t('85.4', 15, 4, '1.55908726006381');
  t('0.041592557006', 2, 5, '0.042');
  t('274440013714550428596728820', 31, 2, '1.570796326794896619231321687996');
  t('1561746015543811.036309888963791', 6, 3, '1.57079');
  t('16746026970714194510554637027', 13, 0, '1.570796326795');
  t('8562893.52594', 40, 5, '1.570796210011942706439386416949134318888');
  t('4612170422.1014', 1, 2, '2');
  t('244', 4, 2, '1.567');
  t('599999999997377467827380555.3333333333333333333', 33, 1, '1.57079632679489661923132168997308');
  t('0.3277802559142', 6, 2, '0.316745');
  t('9188030611.78660756585', 32, 2, '1.5707963266860593675664025493292');
  t('0.0435', 23, 0, '0.043472593484265085227583');
  t('716666666606.661', 36, 5, '1.57079632679350127039399555837851938');
  t('169419589383.1111111188888888', 15, 4, '1.57079632678899');
  t('8753673.837216269216', 9, 2, '1.57079622');
  t('0.705', 2, 1, '0.61');
  t('0.8407834502919054365931692', 32, 2, '0.69911898751614987278540893975085');
  t('124627011231466', 6, 3, '1.57079');
  t('4662597613414129265867628971', 36, 2, '1.57079632679489661923132169142527873');
  t('67640.1676208224', 9, 1, '1.57078154');
  t('9350000000.00000000400006000005000000070000000000000001', 9, 3, '1.57079632');
  t('8653613761369609407536502701140406554', 12, 3, '1.57079632679');
  t('0.64419', 14, 5, '0.5722800128071');
  t('99575937308052038501210224633887193', 20, 2, '1.5707963267948966193');
  t('63238896.5930245', 33, 6, '1.57079631098184399063274071545125');
  t('0.911473962089148', 5, 0, '0.73912');
  t('195000550000020000000.0700004000000000004', 23, 6, '1.5707963267948966192262');
  t('0.000048404293391', 15, 2, '0.0000484042933531967');
  t('62712066.54', 19, 1, '1.57079631084900207');
  t('3', 11, 0, '1.2490457724');
  t('0.75', 3, 1, '0.643');
  t('7885480', 21, 1, '1.57079619997953471355');
  t('9937695765361892', 40, 6, '1.570796326794896518604373190607237457398');
  t('5122371387873014218367424427568798', 25, 3, '1.570796326794896619231321');
  t('584972.0004', 4, 4, '1.571');
  t('81722358209690160494782186581654184581461', 7, 2, '1.570797');
  t('41701379126353723839.671', 35, 4, '1.5707963267948966192073416693731009');
  t('0.137097397337829254372954502168', 8, 4, '0.13624801');
  t('0.214445283', 28, 3, '0.2112458914926452367571461392');
  t('1456645177262680832749338907641.4073706', 32, 0, '1.5707963267948966192313216916391');
  t('0.163226', 39, 1, '0.161799145400750682659514724647885819259');
  t('8238296449927', 4, 4, '1.571');
  t('61274.8711194869386', 15, 2, '1.57078000689114');
  t('0.6116', 19, 5, '0.5489052800783001354');
  t('0.7239729443877518', 39, 5, '0.626634660458277274952105004057671395637');
  t('40356367122222222', 7, 5, '1.570796');
  t('5937.356226365124691450138622', 14, 2, '1.5706279016656');
  t('516871254562033804771023935.36', 34, 6, '1.570796326794896619231321689705034');
  t('0.4802923', 29, 6, '0.44775751308547035376078530836');
  t('7983066722864.62403898971825', 19, 0, '1.570796326794771355');
  t('15402.041039845', 5, 5, '1.5707');
  t('687.41299997999999999999999999999999999999999999599999999', 32, 4, '1.5693415982770808255230832308496');
  t('304933.5642304537817365188181705722', 10, 6, '1.570793047');
  t('31.834587320305', 35, 2, '1.5393942774421917264626386502505007');
  t('432455152519959731290858313333633598248.222222220337952507178398328', 4, 5, '1.571');
  t('47839131888843766', 16, 0, '1.570796326794897');
  t('0.34100528098022586187777710207794405554438106894378931643394712687184898060532918458', 3, 5, '0.329');
  t('485656755339261893972233726018693075159046871351463707579510029365868725737103758860839412307', 2, 5, '1.6');
  t('45914312.770758769380013723', 17, 4, '1.5707963050151957');
  t('0.272435494440134805747955400235656', 19, 5, '0.2659804507893081136');
  t('151111111111111111.11111', 9, 2, '1.57079633');
  t('0.49', 34, 5, '0.4556156532112244921374614168226994');
  t('0.69058807958551256196399175153386550245806483903350425577524239708', 11, 3, '0.60438126965');
  t('505877708', 28, 5, '1.570796324818134282828864522');
  t('832710563.3441', 15, 1, '1.57079632559399');
  t('5490444484599444444444444444444444444.4', 5, 3, '1.5707');
  t('7000000.00000000000100000000900207', 7, 3, '1.570796');
  t('94700', 14, 5, '1.5707857671328');
  t('911111195349601285455161670471771357', 7, 2, '1.570797');
  t('5155132643275823', 23, 5, '1.5707963267948964252499');
  t('0.000043464280901461631639235312', 30, 3, '0.0000434642808740915406500099285305');
  t('161130.1266', 27, 0, '1.57079012063084096980706372');
  t('41313762737270364497922198', 36, 1, '1.57079632679489661923132166743474241');
  t('60', 16, 1, '1.554131203080955');
  t('99.955', 20, 1, '1.5607921585326799684');
  t('60', 6, 2, '1.55414');
  t('2.03563006250822388438897897220855792', 33, 5, '1.11417448168285430706889448298021');
  t('9', 29, 0, '1.4601391056210009726721818195');
  t('71700000', 2, 3, '1.5');
  t('6409.82872721324027', 9, 3, '1.57064031');
  t('70848283833.0307782', 7, 1, '1.570796');
  t('644.21', 23, 3, '1.5692440391917843783228');
  t('8.7825947', 19, 0, '1.457423017911734624');
  t('827.1', 31, 6, '1.569587283737541707286983695939');
  t('4.248022818116', 18, 2, '1.33960189284063304');
  t('6724898590142638', 1, 4, '2');
  t('1444444444444444444204', 26, 0, '1.5707963267948966192306294');
  t('77.8337', 10, 2, '1.557949129');
  t('21074.5267', 3, 1, '1.57');
  t('27499999999999999.99999999998999999990999999999999', 38, 0, '1.5707963267948965828676853280033878058');
  t('1763809699.89165427', 9, 2, '1.57079633');
  t('57659570.8285', 29, 1, '1.5707963094517220927619115909');
  t('174396.3688', 14, 1, '1.5707905927305');
  t('0.496313789909306483913', 24, 0, '0.460694294887438350691447');
  t('70000000007', 34, 2, '1.570796326780610904947035977353896');
  t('0.0000988', 34, 5, '0.00009879999967852324454951230040094219');
  t('538356964444444', 37, 1, '1.570796326794894761727720838352248278');
  t('156284392961599.87656', 1, 5, '2');
  t('0.244368310850529682710606920076', 25, 2, '0.23967126672932687854751');
  t('4536.842', 35, 4, '1.5705759091599414333668369158439957');
  t('3', 2, 6, '1.2');
  t('4638150173683544.416379316223', 36, 2, '1.5707963267948964036281259016647037');
  t('198959.099999099999997999', 7, 2, '1.570792');
  t('2649516060547341218195.43452496675515985263897053576635547518', 28, 6, '1.570796326794896619230944264');
  t('83005995883.284809875953383', 24, 4, '1.57079632678284929675348');
  t('0.24751980942660257174990992545291', 35, 2, '0.24264300733277916188033829871783776');
  t('711588280244444444444444', 7, 2, '1.570797');
  t('6424142.6', 23, 1, '1.5707961711321004664821');
  t('16385111111111111.55555555555555555551', 9, 3, '1.57079632');
  t('7303365848.19514117249829375037236', 2, 2, '1.6');
  t('82222222271111111111111.030721629548095620486175044919664841989307', 20, 2, '1.5707963267948966193');
  t('884850', 6, 3, '1.57079');
  t('63087999999999999', 40, 0, '1.570796326794896603380446723341501127445');
  t('36366663666666667666663666.5', 26, 4, '1.5707963267948966192313217');
  t('8090296400', 24, 6, '1.57079632667129175353073');
  t('75', 20, 2, '1.5574637835007509414');
  t('42933558323333', 16, 5, '1.570796326794873');
  t('130000300005000000000000000000000.255', 30, 5, '1.57079632679489661923132169164');
  t('0.07', 30, 1, '0.0698860016346424992949804879844');
  t('500', 19, 2, '1.568796329461556886');
  t('0.56801547027791573539997804', 18, 1, '0.516569378296737926');
  t('8444.8888888888886', 16, 3, '1.570677911975177');
  t('73', 79, 0, '1.557098553422030830759106714685942522500700602920812852695172620145831141456037');
  t('0.796', 13, 6, '0.672297154322');
  t('5908888892888888885888.88888888888888888', 58, 6, '1.570796326794896619231152455084770105430189790569044460661');
  t('2999944.999155663982490235431535266823188', 51, 2, '1.57079599345545196894157945309127287171563502938038');
  t('8.8888888888888888888638732270887111111111111111', 32, 3, '1.4587673643689087453001632732397');
  t('0.0007203807498723346605626696', 70, 4, '0.0007203806252588883303789228136575308819432644350163789194321190691850266');
  t('334', 41, 4, '1.5678023237650158805993139816208700385502');
  t('1967599962312898580563817494863156402058897195636899', 18, 2, '1.57079632679489662');
  t('833333333367254552320512088114072155486460326380', 25, 0, '1.570796326794896619231322');
  t('3553819', 16, 1, '1.570796045407465');
  t('59999999999999999999999999.999999999999999999999999999', 27, 1, '1.57079632679489661923132167');
  t('7124235620.6709081786680121207727', 31, 0, '1.570796326654530683396955317099');
  t('0.0000000044240602738681616830688886561668', 22, 2, '0.000000004424060273868161654206');
  t('52966687702645000109454138.6374362816074', 28, 4, '1.570796326794896619231321673');
  t('0.3', 74, 5, '0.29145679447786709199560462143289119350316759901206541927220608308729901491');
  t('37', 13, 5, '1.543775877608');
  t('18131946493311290898310608443995253870403889328552', 65, 1, '1.5707963267948966192313216916397514420985846996874977592106709394');
  t('522222222222222222664460188421073170', 31, 0, '1.57079632679489661923132169164');
  t('0.45637922947057938', 64, 4, '0.4281462151861310545072586005382481394357030109096010442355737036');
  t('90088', 77, 2, '1.5707852265373711005374413888489164974636023362374857225182067929816465342191');
  t('5999999999999999999.9999999999999999999999999999999999999999999999999999999', 53, 6, '1.5707963267948966190646550249730847754319180330208862');
  t('0.5387151', 10, 1, '0.4941379164');
  t('7899.99999929999991', 72, 4, '1.57066974451708046945312125786011209109094248832326016835993107763047836');
  t('9056545870881988479', 67, 6, '1.570796326794896619120904319028065752102179582307630101677119368742');
  t('71207277691071369256352975790962098324', 76, 6, '1.570796326794896619231321691639751442084541191321196850500804516071449401382');
  t('40.128693532663393099999999999999999', 79, 3, '1.545881658764101557912291868914587779025308774134740739348596347634586949383071');
  t('39999999995705071725782461038509048015.2287309689474518465575767235055540909139571195222', 12, 3, '1.57079632679');
  t('325455742', 32, 6, '1.5707963237222822174857227559386');
  t('34708', 32, 1, '1.5707675149935907735079008998268');
  t('0.51250288021965633167835344415998343209417282275949726673489673029426102', 2, 3, '0.47');
  t('5699930979414087938396951228625752127037', 7, 5, '1.570796');
  t('28355555555555855555525555555555955585535.5555555555555555', 25, 0, '1.570796326794896619231322');
  t('621054488958.8177', 13, 3, '1.570796326793');
  t('700000.0707', 36, 3, '1.57079489822361233447428012556917713');
  t('8020197462424369246183167789156548734770763005620440', 4, 6, '1.571');
  t('833604273777130626245375417112941', 46, 3, '1.570796326794896619231321691639750242488612129');
  t('36495.22373822403176159847117049771116362607941', 60, 2, '1.57076892594905107477960369084681613816717755716647252681653');
  t('2546701', 9, 5, '1.57079593');
  t('4966689554.003828748144561825', 28, 4, '1.570796326593555265171077741');
  t('0.77629', 3, 5, '0.66');
  t('322020000.00000003003', 40, 3, '1.570796323689499438931961703035237872113');
  t('0.97559153051609751763348337517627742611481175', 2, 0, '0.78');
  t('0.201', 27, 1, '0.198356913139568573361830257');
  t('6790359145460817252747.4583404', 73, 3, '1.570796326794896619231174424024213245621940308680000127509681174999223154');
  t('3.773845386', 12, 3, '1.31176768715');
  t('2624999999999999999.2999999999999999999999999999999999999999999999', 35, 6, '1.5707963267948966188503693106873705');
  t('0.7090839373101640523', 11, 5, '0.61679658461');
  t('0.00009376029', 68, 3, '0.000093760289725251348944065353995890113353563145858872811744107315153369');
  t('739999999999999.999999999999979999969999999999999999999999199999999999999', 2, 5, '1.6');
  t('3406019', 45, 1, '1.57079603319700418235082667408831074689953466');
  t('224359379375055378754690102773775775616.299017882365554729', 37, 2, '1.570796326794896619231321691639751443');
  t('233833333333333333333333333303333.33333333343333', 7, 1, '1.570796');
  t('0.316218487892052424570216', 36, 5, '0.306268934488276138361025280371884358');
  t('0.20553290212929084460404474', 20, 2, '0.20270995334718593405');
  t('0.0815685376979915729591008737250853112441593652206975703191262334936', 70, 1, '0.08138835304095685343216866598571068778486111527151604562996402771417945');
  t('10000000000000090000.400000000000005004', 50, 1, '1.5707963267948966191313216916397523421025846996794');
  t('60.905', 30, 2, '1.55437878877337734993879005901');
  t('0.0000092399', 41, 3, '0.0000092398999997370455296810702947219238127139');
  t('41929279223231739.82570031144682651396988085205', 23, 4, '1.5707963267948965953816');
  t('93349999999999999999.31506163132222222222222222', 74, 2, '1.5707963267948966192206093188491783301542104381434303249352007960174663224');
  t('69463053165048144444444444444', 41, 1, '1.5707963267948966192313216916253552997691');
  t('98404947928251735478107073762973632946', 64, 0, '1.570796326794896619231321691639751442088422609050310641255885387');
  t('937595376537.878', 51, 5, '1.5707963267938300610709214617757762545950547644846');
  t('0.0006488585351778815193353', 16, 2, '0.0006488584441176604');
  t('665811994579552432', 48, 5, '1.57079632679489661772939621096185990656346643033');
  t('0.705', 58, 1, '0.6140737925245042330669578876021929069304552183587385817359');
  t('0.500815438405298575', 69, 4, '0.464299746921244543168638711333367868301982678975602849687729633618566');
  t('0.81771247286102', 7, 5, '0.6854483');
  t('73333333333336666.666666666666666633337484071436666', 62, 3, '1.5707963267948966055949580552767349131729648368024987226805693');
  t('15970010142133202822291675520801350029446872289204618', 74, 0, '1.5707963267948966192313216916397514420985846996875528478701044234980393617');
  t('700000006000000000', 6, 2, '1.5708');
  t('501046.3082', 65, 1, '1.5707943309713896241303257361493987167994789553356517326364134913');
  t('2.59', 61, 3, '1.202329501713780502032305263488582945455736639984202053881549');
  t('4362606085453062063459764539949319285473847514', 51, 2, '1.57079632679489661923132169163975144209858469945834');
  t('731903198', 65, 5, '1.5707963254285957166903821186748842841169386339117549165804499742');
  t('0.70807778829408133176749', 18, 1, '0.616126750476671683');
  t('0.0264192820974324250278', 24, 1, '0.0264131379736383914963791');
  t('4755555555555.078', 40, 5, '1.570796326794686338857489894822343808245');
  t('2902216058659698', 2, 6, '1.6');
  t('0.159747607951903720454693569430377807173944911536222630594866114202085525670695', 27, 1, '0.15840916041060010602404757');
  t('6899999999999999999999999999999999999999999999999999999999999999999999999999.99999999999999', 57, 0, '1.57079632679489661923132169163975144209858469968755291049');
  t('9154439939', 10, 2, '1.570796327');
  t('28466433.22150634323317362', 49, 1, '1.570796291665802917232110844830448147604089157832');
  t('0.8534', 63, 5, '0.706464630664369172305216393996912771532364400206346236355447544');
  t('9.3228728088902424', 42, 3, '1.46394180275564024894513436440039574065114');
  t('28269249999999999999999999.99999999999999999999999999999999999999999999999999999999999499899999999999', 44, 2, '1.5707963267948966192313216562656258462656567');
  t('600000000000000000000000000000000000000050000000', 75, 4, '1.57079632679489661923132169163975144209858469968588624382080562948724153648');
  t('923.498', 64, 6, '1.569713487840017198399177077416910441517907147339565228761275442');
  t('986446', 38, 3, '1.570795313054661472393640177853775039');
  t('393244364845245366537', 17, 6, '1.5707963267948966');
  t('0.0380457', 73, 3, '0.03802735918922804350865333216048723803075130438852481212616381927737475613');
  t('181583420', 33, 2, '1.57079632128778589293263214228235');
  t('5939491193555035498515488345483302513931306610294885655435377269063755276282197668440809833333333333', 40, 5, '1.570796326794896619231321691639751442099');
  t('7458469195', 60, 3, '1.57079632666082084927702881210818854530091443124938062561068');
  t('0.627007512668965894017376111', 6, 6, '0.560042');
  t('63442499', 69, 0, '1.57079631103259192187064683576356331799584338129880815710564368618786');
  t('23624.598034366', 10, 5, '1.570753998');
  t('399999999999999999835051145007103649493682431251835954790666370000000000000000.888888888888245907046237257395216666654329', 46, 0, '1.5707963267948966192313216916397514420985847');
  t('197698625459507641026', 44, 4, '1.5707963267948966192262634875289453271788908');
  t('0.35308276640780502805819885088890564236', 62, 5, '0.33941851498746649469655689401923170807121046971241066440033939');
  t('4861584355350942699325373.09476402502', 55, 4, '1.570796326794896619231321485945490701905565689509430446');
  t('0.000000006868295362887407036', 10, 5, '0.000000006868295363');
  t('9523430.491732', 70, 3, '1.570796221790717624259827266612042512440600788345748498783324304652723');
  t('6796852234584005328234275592784.4890139324961379392144691196248635', 63, 6, '1.57079632679489661923132169163960431516901695633072334535998127');
  t('8', 33, 0, '1.44644133224813518419996684247589');
  t('7245424999999999999999999999.768', 33, 5, '1.57079632679489661923132169150173');
  t('0.000037596532340410079649801418754', 62, 0, '0.000037596532322695856317799925144607608423999975808564979258091875');
  t('48314478017639.3928961', 68, 5, '1.5707963267948759215017584144660608533341397201917725517899867881453');
  t('0.6903000000090000001', 29, 2, '0.60418618802228662374766363157');
  t('5608888828580588888888881.888888888888888888888', 67, 2, '1.5707963267948966192313215133513184632861694155150827378764399788');
  t('15', 19, 0, '1.504228163019072816');
  t('24513831722409.37009665001191', 26, 0, '1.5707963267948558259350585');
  t('45000000000000000004000100000.7', 31, 4, '1.570796326794896619231321691618');
  t('0.7286035882', 76, 5, '0.6296661904808540104927403634770555666927409079414335211077137110378581549498');
  t('211161911.1111811111111111111111109', 59, 3, '1.5707963220591940735507262853787814916061195052537537760426');
  t('886422328890537.1763740552582229990127', 25, 6, '1.570796326794895491100895');
  t('0.30088', 9, 6, '0.292263938');
  t('56060554110701687234415163574173', 8, 3, '1.5707963');
  t('872137330776357191290122750', 40, 2, '1.57079632679489661923132169049314302997');
  t('112278503296588037738350351552357433008361310529999999.5480749535', 59, 5, '1.570796326794896619231321691639751442098584699687552901581');
  t('337700356560.32364868', 46, 3, '1.570796326791935414184973541553878944198689411');
  t('87961181779252.0114', 15, 0, '1.57079632679489');
  t('166666666666666666666666666666666666636466966666666666666666666666666666664666666666666666666666666.66', 45, 3, '1.57079632679489661923132169163975144209858469');
  t('872', 59, 0, '1.5696495383067941543030847388892113661675856953443122679138');
  t('0.83079439820416015817298330581341875232098780575068508', 80, 6, '0.69323801606605310996305125113134558117317461461396887135580404255668358032599206');
  t('2300082589233', 30, 1, '1.5707963267944618522343968263');
  t('7999999909.9999999999989999999992999999999999999929999999999999999998999995', 28, 3, '1.570796326669896617825071675');
  t('0.29150810237754372465', 50, 4, '0.28364797013176089751590471178706116362084320455491');
  t('1.77777777777777777836', 49, 3, '1.058406866484158912704661323874483285565386392709');
  t('30700.84001209', 45, 6, '1.57076375439625044062570414196203485310244523');
  t('0.891', 153, 5, '0.72782041553354958303913201300903988914064827250724801937209689246758416275367880212735809631990575320696888573924272479754566588349663699040857181163425');
  t('906317697', 157, 3, '1.570796325691530764950755878530405749599575268320617717275725797829105760331296118586908636465945223102997618499297104678674691982441818236599482793981537002');
  t('0.85', 37, 4, '0.704494064242217716657480340781996257');
  t('0.00008370604802800671492094992620071639930377642969883270421852543091726', 73, 6, '0.00008370604783250559107180834532855622281614857907411057048026884123368156074');
  t('7888888888888888888888888.8888888888888888888888888888888888', 85, 2, '1.570796326794896619231321564879188061816894558842482487952261028548274400326882030599');
  t('0.86383928297450579688', 4, 4, '0.7125');
  t('24980094974432649116267396.72146170315335712960535171', 126, 6, '1.57079632679489661923132165160787802354237207417932753470776237077804237503416216711536785188583135919384541257336071501491794');
  t('0.3367191', 139, 6, '0.324794643012269668145812262833071987526221582495309584584939219045666131940533124124105426926748564324610027576505157987726084252453634419');
  t('7.1726775438209516202963486766150272', 18, 4, '1.43227129188655828');
  t('0.00000000343383458943225981866094003', 51, 5, '0.00000000343383458943225980516457368167930391349102772876147');
  t('738373104150.198296165326', 126, 4, '1.57079632679354229037727857076020870058799344852136050641573907383290482849632999398276722680466941054991354873790091003857708');
  t('1491972436671215526.69530919', 142, 5, '1.57079632679489661856106802245593595073831284110950344417372088654338770309655837936798641728914183274893857998844788522975511340695896955733');
  t('0.00000650428728329', 5, 1, '0.0000065042');
  t('0.000000097250350885691231905754571833508453940664369958603339', 132, 6, '0.0000000972503508856909253197849948398909640297710232807534798760313170620560381106386878113819154521286882079307258358816776877952554246035');
  t('48888888888888888888888.88888882888888888888888888888888848888888888888888888888888888888888888', 135, 3, '1.570796326794896619231301237094296896644039245142098339929621056484489568188183219981931574955055539234803125558750700254934410000416');
  t('299999.9999', 60, 1, '1.57079299346156218713255590143399000986329823015481051953951');
  t('3670.663411', 158, 3, '1.5705238964837262074632703958809997708820874005803788869815410336937092022957270242820516179688428739645959782296790678946103319492124406668523238044746957077');
  t('729611.41298476814149262974217658791464610785685682', 146, 4, '1.5707949562023014342509877919264195764766267256308646467858915181437045055324678845784864041794421249756010179316010974919541202029727340500811127');
  t('53786089063991493.5244744716107163333333333333', 61, 5, '1.570796326794896600639153764905769975060509806040036135181518');
  t('0.40856637214499536855779', 160, 4, '0.3878692977463101555527787525625812682336184873110543577993245386157879232908092110798117033420955981218936917557216837604097211171993249492378151588459297040707');
  t('280844', 49, 4, '1.570792766099279138445491931295445307261458651345');
  t('5543095336613849943113', 151, 3, '1.570796326794896619231141287021163215342684231706946099363158912886261787669777673922893089463013721687744579932998328272961742687569496522112307409235');
  t('16.2', 34, 0, '1.509146156155637583866297351865481');
  t('0.9448898382813544', 4, 3, '0.757');
  t('46378931002856702', 112, 2, '1.570796326794896597669807047449155975529692942577809289760713904561202307578943708096802270373606182772134391028');
  t('0.0099564341', 78, 6, '0.00995610512387108776163169003042890483408549733242934562262847215446581618427486');
  t('64.9644', 151, 1, '1.555404496357436550554248929965434555273613259143549939101763708476874929421333953273620136545846698528807836277150991594953032658396541298478828449561');
  t('0.53590525975620433555318302542803391385426', 83, 2, '0.49195755234809552361874758395823200938044980313999018314705191468489182589343333105');
  t('245555555555555555555555555555555555555555555551555555555555555555555555555555555555555555555555555.55', 109, 0, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058529918675854');
  t('7.5', 48, 4, '1.43824479449822259796140424793548158553861797');
  t('5526', 129, 2, '1.57061536407519264444510819307760915729866850748780233939237134112675365932923837410120391680409359191659914196323589834127673103');
  t('8790172697166569724756465912166530026005.9321', 88, 2, '1.57079632679489661923132169163975144209847093627988717251130090940406471730472305888004');
  t('3692638477.755336666', 155, 1, '1.5707963265240875470667822605341491886088004649857927478454693540313661101155302057338683899346704760356610209323785368570510330335574407431426668897636102');
  t('7355030939457156999140', 57, 4, '1.57079632679489661923118573028102549149476959215081546177');
  t('8.395227', 65, 1, '1.4522396309727100376524446217894330118152632111444906054395817478');
  t('178.88888888888888888888888888818888888898881888888888888888888188888', 92, 0, '1.5652063229095709072713935220511003557181651704857651377025446391812580459637320870026670723');
  t('0.37277270872737448376519144151636314403394201272146565221552126308', 141, 3, '0.356816548111846931013750476199712075870531188889466355768028649103228372128117716909500778122103586686438159716350936160033869955511906237911');
  t('2999999999999999999999919999999999999999999949999999999.991', 132, 3, '1.570796326794896619231321691639751442098584699687552910154138962820574869809762277091795190448836305976259228440826338508429490206');
  t('8087362599850.419277266404890123046429915662', 153, 0, '1.57079632679477296952628453952637331149964265489542947015909573155093659563171485983338801234119603213960919978738575287435717013858340450653413308572238');
  t('93.688414995', 75, 1, '1.56012305383103670436636549472962023620491089462241939805393023652202992952');
  t('8615.223343626562901463', 149, 2, '1.5706802531940597052524614121998662762145372560363266629023628536682628108681796075707954434916093326247461358911112887807415457178170226975724066226');
  t('133433439.63474329244850113472200327505', 41, 3, '1.570796319300523374133465577425740481033');
  t('91988182549', 141, 3, '1.57079632678402565763288677439723880018923014032092270137680806153248804363058467151311381339256847412711041926331743133139772739220542840859');
  t('0.92867134294481499607507743280734580262539320828632393578', 47, 4, '0.74843169750042637622234166761584532294023555316');
  t('9583357357109736336496395118118710107531.20603', 69, 3, '1.57079632679489661923132169163975144209848035212304743826598505894319');
  t('2799999999999999999999999999999999999999999999999999999994999999999999999999999939999999999099999999999999999999999990999999999999999999.9999999999999999999999999', 133, 1, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775');
  t('0.99723686631888721258290476902737237761605653168727321169830155438876799291599192422782996706888533555864601', 62, 6, '0.78401468607193846627011830196321569363183092183745080554664119');
  t('15965557311218866130.547911230719318432395595115814611123', 114, 1, '1.57079632679489661916868685963815834990726051559002096846712031354901402537761234460061582102434040890079086016594');
  t('10.20869', 80, 5, '1.4731520800712391710865380511034472946435817650532576253411114210983073949236087');
  t('0.00000007567636907353640008113672484759815626929005231434602557941606803280938528551', 114, 2, '0.0000000756763690735362556171469112579274987421740876307022819337534993467111827147356779451323396995616309954436887077297');
  t('111111111811111111111111111111111111.111111111111111111111111111111111111111111111111116', 112, 4, '1.570796326794896619231321691639751433098584756387552553277474546576894025478293818602324701154722616543990566173');
  t('543768285595139032090925610543128429', 30, 5, '1.57079632679489661923132169164');
  t('444058333673427941477305318147228888232696204342850549112275869889441025283706755', 137, 3, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044970620610272844799488472993955431611981139589886609744948');
  t('7555555.5555555555555555555555555556', 138, 3, '1.57079619444195544276150627845025418178785854411353686880290033695845419485148977454750129877649106279515094585458539430757405572817252121');
  t('903501.661', 68, 4, '1.5707952199900691739925010132039003339137276845643754317094119499645');
  t('3695052043060649319', 64, 0, '1.570796326794896618960689508832472280208508173209661539205691275');
  t('200000000000000500000000000000000000000000000000.0500000000000000000000100000000000000000000007', 2, 3, '1.5');
  t('0.65', 7, 0, '0.5763753');
  t('468927452136649384592176518', 4, 2, '1.571');
  t('5479000', 53, 1, '1.5707961442798391269902382668183969456587544210785386');
  t('18354245577', 22, 5, '1.570796326740413312042');
  t('3214.949', 67, 4, '1.570485279880077771803504868506915192441959459871910207229084636172');
  t('0.4920935842762684', 54, 1, '0.457302494460990195719285368461930730727603132848820234');
  t('0.77238015392760633326685406485060350137396', 77, 4, '0.65767122650559877721619717468438037932308225912407690660966062454704318155313');
  t('22461440805333137319', 5, 5, '1.5708');
  t('242997268238925', 72, 3, '1.57079632679489250395872110932170700272792796177636928958059530436329804');
  t('2999999999999999993999999999.999999991999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999939999999499', 94, 5, '1.570796326794896619231321691306418108765251365687552910487472293931685980920882270881918647239');
  t('0.00342304584155791', 128, 5, '0.003423032472098783321047120870270043452396731719690058135732199597984336600554537998430013202414353368717003980446329370792024286');
  t('35866951989419129', 45, 0, '1.57079632679489659135050259402021158696261557');
  t('720928.5094036203012341543208', 36, 2, '1.57079493969480700480202867321269511');
  t('488888888888888888888888888888888888888888.8888888888888888888888888888888888888888888', 63, 3, '1.57079632679489661923132169163975144209858265423300745594201775');
  t('0.604443114', 41, 5, '0.54368009287616794530579107010184222071658');
  t('0.56844', 29, 2, '0.51689029087881511741617321399');
  t('199999999999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999', 92, 1, '1.5707963267948966192313216916397514420985846996875529104874722961539032031431044993140174126');
  t('109008000000010000.000002000000008', 10, 3, '1.570796326');
  t('0.08204476241730069769508505', 102, 2, '0.0818614118866079025348731485850658741956355478438841221625587155269264363425939330076969131575931445792');
  t('176236827524998360801743172031959847949685789080093650.9663763530924338262', 4, 4, '1.571');
  t('944444444444444921122802887338757235699999999999999', 73, 2, '1.570796326794896619231321691639751442098584699687551851663942884389736729');
  t('15.4033043129943373289171773742085', 99, 0, '1.50596617061861888550490921896009836585981677079317459520459024459278979890571195158939720295921646');
  t('18868808.88781569', 34, 5, '1.570796273797380668675628304658149');
  t('20742579530635964807923946343362368352.7339549350162058596090705186671910118345642199879284102', 150, 3, '1.57079632679489661923132169163975144205037468807723029941026506524120922981314245648707117401306777467137631646443174261845782795585630069237867126836');
  t('78888888888888885628441441139319280571', 6, 4, '1.5708');
  t('708643', 138, 1, '1.57079491564711134605961091102649572945774414637794421074013677704770177577706522361237479051531785077853512550404177645790191727401107374');
  t('0.1564', 102, 5, '0.15514316373974529695570262744698028353478633072072394559729846113250250632481223964938889142940044672');
  t('27633985697303956321763128343896978874956', 4, 2, '1.571');
  t('0.77215088792322157403591', 109, 5, '0.6575276115836581556714088214136951891916680093630465935719907941252266671745985485357482494549978766010284567');
  t('6.7402010217518', 131, 6, '1.4235072241833326993778366361688590022023188920984058955249168382797148589492631651202853736185037998020021687087234368833829817448');
  t('8376786791117.7722844183', 62, 0, '1.5707963267947772417152244288704403730975715814069093602374866');
  t('5481446395116666666.000000000000066666666', 65, 1, '1.570796326794896619048888091469751771764895500991839457020966975');
  t('4957777777777.75', 56, 3, '1.5707963267946949159592463879547263856507167340585421525');
  t('4.27', 113, 4, '1.3407501820027851923322054408493946331375175799081128074766773707959861011094389181545509715340773264499278603397');
  t('0.052799338758599964089178308270590484023057114282', 116, 4, '0.052750356522675710920487510424048519954261199162968670024856053429198122589063078290239125893865328765129524250155687');
  t('3930665555.555555555555055555555555555555555555555555555555555555555555555255555555555555555555555556555555555555575555555555555555555', 160, 2, '1.570796326540486777980235856308868214737048759678362334334242981341356950309057319614979226426028541803451136567741310144811498181676022973614513108831165659122');
  t('2777.7754177777777', 99, 0, '1.57043632650459239779543971191193764408208697728748774312903600197511948394155914426304034119894954');
  t('46433333333333333333333333733333333333333333333333333333.3933333333333333333333333333343333333', 21, 2, '1.57079632679489661924');
  t('0.20999999999999999999999999999999999999999999999999999999996996999999999999999999999999979999999999', 146, 6, '0.20699219421982102489585928037957669648997068434550899162578247984698361799473299191912161430591578184243964684074636606130922672690274664699142549');
  t('90000000800000.000000000000000000000000034000600000400000009', 146, 6, '1.5707963267948855081203093459598611814753874735855576232562923974511865821861190727294658890235988467637396558592900447969244872686285877073289933');
  t('63989999999999999399999999999999999.99999999999999990999999999999999999999', 7, 6, '1.570796');
  t('0.16209164433093355561797026590015118', 18, 4, '0.160694028891685685');
  t('380000000000000000.66666666666666666663', 130, 4, '1.570796326794896616599742744271330394083810923140923175983333370816557422473890845393370820098655941181044573520170760760174980575');
  t('203499999999.99999999999999999999999999999999959999999999999999999999999999999999999999999999', 11, 4, '1.5707963268');
  t('10332363707535786736', 31, 2, '1.570796326794896619134538416457');
  t('28', 139, 4, '1.535097214115572649844638318565080320341635058039745769320719199329879987994997792942024046760877779472495270082277167112175863421353036257');
  t('0.7427429461822151132', 145, 5, '0.6388403929080696111332806831591739238407940178740807722211744148273028772050118653384413305227929858873856578945086517545657877062281716813029475');
  t('90000000000800000000008000000100000000000000000000000100000000000000000000000000100.000000000000003', 157, 3, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499302906301560046188312061807317010142197194012764291964453934587446505753883');
  t('0.951296844818051332709920623174071477383107539510890148451325553393', 102, 3, '0.760443966630206694402037800879178674641200667594709331469340719313174819653166746284517430085227949587');
  t('595955555555555755955555555155155555555755555555.5555555554555', 35, 0, '1.5707963267948966192313216916397515');
  t('0.000000007', 71, 6, '0.0000000069999999999999998856666666666666700280666666666665490176666666666711504');
  t('5345259370250880674076679137789221905403488578366381754643', 154, 2, '1.570796326794896619231321691639751442098584699687552910487285214493181781774547117071028585768385813535758487986318284071335040739588346750847693169977407');
  t('4825.73540294722188167638200669950159597078474772207870757047409176280332663208030017243603197680412434148834182', 118, 3, '1.570589104495664138292156284488752158314525299767011289229821783254592618427681353983529392339645861248628371525181911');
  t('0.231374819050204450996721497877884862549945965879513017366068913641241710319620078604635944', 91, 0, '0.2273737403597054405744905714891331872904826684523023915912507877226522861938187142426366906');
  t('832621.2', 111, 4, '1.57079512576854754294167332620284778980958203644887261196104636879615049627171182975538049689566765953312120575');
  t('87000.090000000000000260504', 118, 5, '1.570784832553914156330328420928855138690368838672803710623041096665875605978303550202126363448743482338129762640669934');
  t('3512563847', 105, 3, '1.57079632651020428521038225674925066738533957502501765864950613051804375884493439275993154163190963103129');
  t('1851392800', 54, 1, '1.57079632625476272652092549700036870676089475214381822');
  t('82744567587346758193326115.63733649391654106058445388416719615779584', 148, 1, '1.570796326794896619231321679554365909756769604292708256371751861747163957685353474120590079746910014753855544745120610335466159633954827076055923111');
  t('5888855654034051317712681513446412150060205005', 65, 4, '1.5707963267948966192313216916397514420985846995177406313709059813');
  t('0.5845852661194268362485378', 91, 2, '0.5290080240316160557625784581000648507254673679148610451286551693520129599422911415209805951');
  t('63', 55, 0, '1.55492464380310657002248088180552973991777177995041711');
  t('0.2001', 33, 4, '0.197491711846661422636422619317907');
  t('6557.6327', 112, 4, '1.570643832741326262782943096948281273161877736390502759260150791490457063586973472005511438874777361102803932331');
  t('0.00065160303045668726016', 69, 0, '0.000651602938236092036488893764506673822028547601669575965619145635262712');
  t('309999999999999994999999999999999999999999999999999999999.99999999999099999999999999999999999999999999', 96, 6, '1.5707963267948966192313216916397514420985846996875529104842464897022952998652689113847770372221');
  t('6688261844925788807049', 127, 2, '1.570796326794896619231172175962407159574194299417619370922517634845914870976548479203006976340869863827904682595339682825847712');
  t('5580216.473857594133', 21, 5, '1.57079614759037925242');
  t('9463390489.644282062620825402474433905505041236026466533805068115154333', 98, 4, '1.5707963266892262465362191727312805687617115925817871787704175237942234788918283300605764940737517');
  t('8200000.000000000000000005000000003', 52, 1, '1.570796204843677107036804297328464480140215597057891');
  t('0.9695631467734992924397021957206981362', 90, 1, '0.76994578721520423442316998481122287766948322622594148964739748389382693880076756940822196');
  t('9706568704840240620723548616021191111111111111111111', 129, 2, '1.57079632679489661923132169163975144209858469968755280746445454309933964050139711068992429527066657328197205628756022847054871838');
  t('0.869932019386166935836', 77, 5, '0.71595241961162653819025190913803172812602831574116121492408984781142247499518');
  t('8111111111.111111111111111111', 85, 0, '1.570796326671608947998444979311608970174074973891502310801334595553981149499578229047');
  t('43483884414', 28, 5, '1.570796326771899593701605178');
  t('0.030319481690988', 136, 3, '0.03031019620552842948453397594215863776363782898826569738599914355720226150801464325457229448573641550642424666391370342066633280934681561');
  t('3528470161494643555555555555.9999999999637', 128, 5, '1.5707963267948966192313216913563424987800999971607736804991467168295772437285880447470545563797917674260870724977037953207987415');
  t('0.00897', 134, 2, '0.0089697594335226103784495692063512508140245236561900729560761342352707937893915909632885764794079816618286748400586057641827962939396326');
  t('5570780761149.12587884901281658595686', 79, 2, '1.570796326794717111179779967952798871581805488390559143749953804858660613534775');
  t('2.13616180852614003304685637018368399982694041780982219265648350639508913984708752943267410304198479440607063624031976', 123, 6, '1.13296874679099641190594582521478361645534434874607989203204171127392422372999047186113855633360689518518114824587291993886');
  t('82036019184901113885124999808.26492', 150, 0, '1.57079632679489661923132169162756167460455139692145265020225462684600410505087798947893497197477724848505765766883233995858575777676492901394804084314');
  t('12479395585265969766975314307378024719715292006', 138, 0, '1.57079632679489661923132169163975144209858469960742082450883174584996372553862005713336067133209126021311453404743157993102191310646260658');
  t('0.800000000050000000000000000001', 62, 1, '0.67474094225404046793382614910121135971397521180192325807978906');
  t('95291529173.510142502', 142, 1, '1.570796326784402507019320506364786873112070124769997268481656531847251471929648837488301654332323350715101787829785954611332860592315381795158');
  t('388.0762', 136, 5, '1.568219518975488538564637402037546308061409925378740787685513919473875745473360188029576364996140523815145289832551764832405453782931049');
  t('7425248310731450.841265298', 129, 2, '1.57079632679489648455569090435212784979022186758952047856010459452716365051048219327919234716653587869661271987923159832175653553');
  t('727063193610', 51, 3, '1.57079632679352122296757353037213296014335649909952');
  t('54868336885984188320784372400392452808043436969425093608562667538954025534239', 148, 2, '1.570796326794896619231321691639751442098584699687552910487472296153908203143086273866395809173146903230706318206031737929009832951875542274855389527');
  t('0.00261565188219583455', 51, 3, '0.00261564591710870096646796335439963855538889353892924');
  t('3222222222222222222222222222222222212.22222222222222222222222222222', 49, 6, '1.570796326794896619231321691639751441788239872101');
  t('5989357.08272921275684315212875033562763478515', 25, 3, '1.570796159832068023893401');
  t('4000', 93, 1, '1.57054632680010495236934253369239238729097368561062513554458361613239325335696367029539131233');
  t('0.34056963738681793', 15, 2, '0.328249028886227');
  t('68530036704694773358840089545387193350012109720', 25, 4, '1.570796326794896619231322');
  t('969683263580505049.24788868781901752307571789486', 26, 2, '1.5707963267948966182000572');
  t('510966595319205454041302666666666666666', 30, 2, '1.57079632679489661923132169164');
  t('4280070000007060000000000200000000000000.00000000000000001000000001', 56, 3, '1.5707963267948966192313216916397514420983510586489721511');
  t('40035325763009957', 30, 6, '1.57079632679489659425338081214');
  t('20000000100000003000001000000.004', 129, 3, '1.57079632679489661923132169158975144234858470593755534173745670240325898427587715654101615886610971016754332464786321449003969935');
  t('8833333333603333733333333333335333337331333.33333333333', 8, 1, '1.5707963');
  t('68888888888888397887437712345046986021514978113965830437892.11111111111111111708155221717296436193625142872426376949914022866978187444', 136, 2, '1.570796326794896619231321691639751442098584699687552910487457780024875944975125525470884388060228642345463573702322488675446516524393811');
  t('696666666666666.666666666666666666666666666666666666669666666666666666666666666766666666666666666664636666666666666666666606666616666666666', 2, 6, '1.6');
  t('395170605059536366591842700.372875502291287521585153149809', 89, 0, '1.5707963267948966192313216891091988473544991849277256522099137405818334867922770021782376');
  t('0.000000006100299256076476396893962863508266623843629072159629078', 142, 0, '0.00000000610029925607647632122249366527969925983327236105878073266784406813854182175877275714148149890023926352235842988134330708888579363473403181867');
  t('93097169174003036010960525601570065988256145917422546023787945111111111111111111', 154, 4, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104488572552243832761749519017084667501361668564726862640257124609594479170625');
  t('9971935873537053813678031776291153633548649350546569634319054766348359', 7, 5, '1.570796');
  t('77777777777777772073077596588340229882802396485751712287746117', 12, 0, '1.5707963268');
  t('0.6203302598', 131, 4, '0.55523425013080956182595058866654433847407454882201835618747358745171222287438373248245498651232452026030022970026320848041434738192');
  t('11050000000.900000000000000000000000000000000004000008000000000003', 40, 2, '1.570796326704398881682131462119118062316');
  t('1333333333333337519080804432187181419135356114547426742522718903433889763255890.8461230111111111111111111', 16, 3, '1.570796326794896');
  t('634173', 3, 1, '1.57');
  t('8.89896734527793', 88, 5, '1.458893184759122792158225305813254373506730385987812330960020587986859153855838691176302');
  t('0.00000294917594144772977446558908234939705837964143641360868783003128444879494085191857911100348244', 12, 3, '0.00000294917594143');
  t('64795.149439', 31, 0, '1.570780893540886424635122179096');
  t('42322487542565884048528485382.585396627108', 107, 0, '1.5707963267948966192313216916161233413402290145961961244433944556481120532128200423720328163999779906321705');
  t('0.000075149525341903584486177570029540645768418879863177035165053', 1, 2, '0.00008');
  t('59999999999999.99999982419646692690772', 34, 4, '1.570796326794879952564655024973085');
  t('120', 151, 6, '1.562463186354760701025428330484986397146166238123699677455683773580455286623105121977403281243654329806415745474305039276474011233022700464887136982361');
  t('0.0000468723843279623692731497645730854530240088573498391946002884249786041586206152128184479020561733921092447904902868096849343282897850058556545690230200139994058100652770260349027071', 45, 1, '0.0000468723842936358409333283673165394532872139746');
  t('0.61868911206414822770670116437199356068021414860656', 176, 0, '0.55404827169811636429956349128620144971321421320596403589610554906644750727501820337004605292940117347201101775449901426693525301348221220186563134486620124399666531807845394233');
  t('58653026131607150459340630511838262798279628.1557157258509165549403780259018956616464961', 131, 5, '1.570796326794896619231321691639751442098584682638134219690946484918742317735834537104605481995550564817714943605788199286822043816');
  t('6911608247558593382930830838772165646015578437314230623518153775516742365680079691991022648687100638199542513316487210609475232762443355779222914905379288.099245190642765209308089151111', 57, 1, '1.57079632679489661923132169163975144209858469968755291048');
  t('487938651.58093236130382529692595075442336', 20, 2, '1.5707963247454586484');
  t('33936084315.25460893158171209983922319993', 24, 1, '1.57079632676542946000604');
  t('442775.888888888902100060918972688337729577705971964145', 138, 0, '1.5707940683160022338104677716950948972833304809031478027478511208746443168787328785129390173995762788365691535716098952480685810623731299');
  t('0.411687618649111532829470526308851349377627947016376721878010709911065710631079094631', 10, 3, '0.39054113');
  t('10000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000.0000000000000000000000000000000000000000000000000000000000000000000000700000000000000000000000000000000000000000000000000000000000000000000000004', 202, 6, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533990974043256641153323546922304775291115862679704065240558725142051350969260552779822311474477465180982');
  t('0.00000000898565176768454223931521406797077992471637944796253504923315559594292530834568069936173934454202180026869456617875072096700598807859564106955960872612747451527496441237706666149041659489212875518050882457289898147638756447733746981648903384938653997', 170, 6, '0.0000000089856517676845419974755690242196622897041321186081460974857872115674557689811036878449002117027333289610361875356765409131702137968586674538602706279159083322006802830252');
  t('0.9361683426529030224192148567796328111105045847167201041640680910212791136852922491974', 114, 1, '0.752442069140546656721768417528010431905637906648289428804040064566391619212987223378470053188738596868148212512375');
  t('0.5899999999999999999999999999399997', 299, 3, '0.53303411017749002604051892167002441580815150728315866293306595711486598159588784043904047368018708200986241667636714871975084284449314870816194965615076964844275480359392843689599687301417479877084837179497443174995278425380705835533104599592893823952726279837008096018413990040468494339408358379384');
  t('0.572336790283068059662994986181376976230115554048300183543514346097186188278741515654284583791203210331925598175496267651265207186469883007750291759899216087943755655650246454368147418511174502199578874950181295971565518229387417495375385709506147017335949', 90, 0, '0.519830503674391245336390637686179707684423862910240411429624183328645410510714242826002527');
  t('0.9', 26, 1, '0.73281510178650659164079207');
  t('199999993333333333.99997440765369976624551', 213, 1, '1.57079632679489661423132152497307923654220526135164622632397301595293003743005674730119423943105117932441257351876481735449694763035252521536756773252702676526185825272870071477861605582594804015190062028364758343');
  t('90000000000000009000000000000000000000000000000000000000000000000.000000007000000000000000000000000000009000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000006000000000000000000000000000000000000060000000002', 287, 0, '1.5707963267948966192313216916397514420985846996875529104874722961427970920319933893140174126710584228799629321455411533235469223036641800056157662349284379167498222982656865445045082418388818847619396213753565732717459487615390010191468117928990700230172649291255514728285664347199475107');
  t('35264012750837', 111, 0, '1.57079632679486826170981483292996099831933449655003759008810412868552221509776478984631336635010295640760326012');
  t('564749', 250, 2, '1.570794556096763468123703899632725909747125599105758531545124483276961974290310512400416468655670291970701843521473829506749076443579063726913746769385623955242181273776200390190535829013192755820730491336529343429073446644683505940580796642504661698');
  t('2803903212344110705418236190127', 45, 0, '1.57079632679489661923132169163939479640710808');
  t('23.5', 263, 3, '1.5282687921751124181979180089509372269354209430263398250359488036539709046867316728312930258644636266002135399908774053586336049037442025956506440519270418054144384879723548291277179296559470366238129455585769983655030875953227595675022541429246569920391534175701');
  t('647926222.8131782368915463136351491171892883899825683118932486534142673800953279185401668464158794111', 82, 2, '1.570796325251511022553074548780077588342082239170004320629809190421166065083637541');
  t('8', 60, 6, '1.44644133224813518419996684247588041652541450791774882057236');
  t('354095536260062963303.11334362988054635', 86, 2, '1.5707963267948966192284975950398283155060773466352626149889082298841177979078574452449');
  t('0.555674708431954992118937361153721870741472547192793523806933100089675633392360005376048379956941491904269527332115127376', 40, 2, '0.5071895505695356456006428256683221297089');
  t('0.092549032636349866635837514177374902527802435267451', 238, 3, '0.09228614488451000140832357841099007979078642525942932525840189637044064110902516498363177246954275136738505793330018710131086961566011218711515773509704359485813633518057785124154513026004144994130724038144485754576125190579081004694405201');
  t('955555555555521587649882625859701045233566504736214833208295401000', 244, 5, '1.57079632679489661923132169163975144209858469968755291048747229615286169151519748536863667298199457417808240652041533498800323179586357674505436152553313676202525950842807162169619144121006665496464548085584245470950305556971101224515705930407');
  t('296666666666.66419693392008772792705166666', 265, 5, '1.570796326791525832714467730993880075985374057841468275915893354826641213211083294784249800550856322311376065289164447887194248942877875619873773670908939153085781700895788159423368591307377985834161116469518980977221746492356167084338529449499048910062191001352842');
  t('933316615895583293372881638795159454', 227, 5, '1.5707963267948966192313216916397514410271369369790434471725957061977292011500215356473130303153985359320370849927276690401029396911653606326845526925920406824978774819036215602495281655853581425565927411181575160939871874157379');
  t('0.84', 271, 1, '0.6986598247214631978047509528351475335769933410589883858488616509435653373338071776895397677317291959944201753522123675882395557336715313553466544949648617515836443841444841302373786292363331927896023651658590705826934626221753531746414166055077082236329561481876896909845');
  t('3', 274, 0, '1.249045772398254425829917077281090123077829404129896719054669236797151965737293954957608990320417159552066873879511414175279279334012656713402870421976225900081907291840364731808892667143663044249449380274680981203022155450131429257930709747155985592381433775037358959307224');
  t('30398831865316617682694256604268402.3', 34, 4, '1.570796326794896619231321691639751');
  t('2832515244395855500126331660451135856', 58, 6, '1.570796326794896619231321691639751441745541586511549843629');
  t('58810841242747826766708675493009641103684316291546998259609172889187104831875565340559637757639079277089481128865797532420116181478272381514341673', 158, 6, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710585339910740432566411533235469223047752911158626796870605728868');
  t('0.799352996639581931514176140692', 235, 0, '0.6743463034473810255870358887526461136227776792980521608430010135836718453512318325920503398921773072224617571522825790313120424908603543013048038996094997296808435787072076908737675040727586187740875238671016680531111643467499588408058');
  t('408725088315490079236953.54067613', 218, 6, '1.5707963267948966192313192450074585202807195765993504845028464068052213893761707292702358554921786233518685367093208744290564484301878379618356230403940639033462420078794034830465970486376463326049647971209177819532857');
  t('0.0000000519909185123801168477696333864947846590579316200399903453228890261530630997732161827625535742648256722183145414538808', 17, 3, '0.00000005199091851238007');
  t('0.363733707362466263709', 229, 5, '0.3488569760116356993862822255999079782346698579116878243594884964292596184419222473725021954272245473799154148853082734105394510512826857173318770881544012152156440602303555227340620439470288603830447860571786332528629993486692623');
  t('30000000000003000000000000.00000000000000000000076', 305, 5, '1.570796326794896619231321658306418108768584699687552577154138962853908203987557956103971977201922756855978981524868193672524184043131503456967115045935171353959662199626597054271864516675911832758199577255308556283158695365959837062070407184724979148830797306331157697246080592276984986165848815076963115');
  t('0.64520757926392376278112058954959046603494519820177', 12, 5, '0.57299882675');
  t('45304430211377593508961341678', 105, 5, '1.57079632679489661923132169161767854557755388103224302918540985734028430937559034493608583969428217494013');
  t('8', 272, 4, '1.4464413322481351841999668424758804165254145079177488205723581770381859357155377406903068183577052036646949919532027742797357592208068960691504359171925291701341180388419292333648987957622157075751812495553453708836411082907140223703558710768873849320927571288195385677249');
  t('221835.3', 309, 2, '1.57079181894605564024180585585700005557383872998390059221166066952679086595306158371898958859686711205919414491812678315215982009228877662161719858482111952165397594573132097678286726172151455366332293558681744472843665711790062577493215172363922211461291559018694632816091387926842797258739899573224230498091');
  t('452745913', 306, 2, '1.57079632458615221914658807556000549778836685615997141744306762263070010371980839204048980063758586416583538146736282816803274605028110149960153660248229729640669090534930726631818932417783166586098848841206412626536973865890121937060262089382214649456765454202824649400925646052664705930375300648789736802');
  t('47777777777777077777177777777777737777797777777777777777777777777.77777777', 166, 1, '1.570796326794896619231321691639751442098584699687552910487472296132977970584964657777789181190091927207274238540123838239618910512063452910976085265190797031384521003');
  t('44344454162993104966732887230795.74159765', 297, 5, '1.57079632679489661923132169163972889136436381186672061574224406031030222930648439904522980845919400837850361631648447254996978611018693481758501321358230821615451370608446510049820543040654089917576365166663434433069055163063343016951070956287877383705033263283340035444562748625951421665015068242');
  t('54821459948', 299, 1, '1.5707963267766555873261419744437987187956806966999771878607405209125502961771725600219461487401120981596093700359382752710242827606863005418079399908664710833008850590974863420781588801718641287443608962077544850766277247640171316265523275968722314153381412421312311725667129914836699341317053939856');
  t('720999999999999199999999999939999399999999999999999999999999999999999999899999999999299999999991.9999999999999999999999999909', 104, 1, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044993140174126710571470285');
  t('0.530519957721770525164227509676020102422905339146079098447853617114966826894345141', 265, 6, '0.4877644237175817255686025353527136827879909550510587346782566843081022423777235473110364250482868734899423638048742437047686998611667315056095155303177827718357483057672776317642364127711072474243337904837081382962091643636587202501108520675827279791435283181300129');
  t('209646.12897193', 283, 5, '1.570791556852303849926379586469919300090099803764407762769510464024712639918772298439252586308060281963180472557168460153367929791592019947451630509997532605499932069907809967647793454191463683978554783119328556918845923573849034164333766521027451793563826015305917261912928866051061');
  t('50171384773937327', 100, 6, '1.570796326794896599299641421983872515499911366047934238759881790763266168282276658625728275635326092');
  t('857588463422233285008588200887117058796576663867044508520237282306951566594983497929110854926234443584147979813854890247798056014805940806412425280451611967973348999', 295, 3, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142050184908798394194952747822059163826733711760225532900923676496920307395670054811535247471536965807898603333185520552527228910801336');
  t('0.000000406861864500640464715422795381084241255744', 182, 1, '0.00000040686186450061801454199820657225074005925888393565793817450159983026544751351534204640329989390753248634146008864196593602392941664838697546123028297551828542303898439850313741664736');
  t('874005415712271511928743029984913879951424386220690458199580', 111, 5, '1.57079632679489661923132169163975144209858469968755291048747115199623821313613582240951526725435352645318771697');
  t('46799999999990999999999999999099999999999999999999909999999999999999999999999999999.999999999999999999999999997999999997999999999', 212, 0, '1.5707963267948966192313216916397514420985846996875529104874722961539082031431044992926498913035330573309819977585819311517465919202959969492251435738287823652358619401605707975624544142605714336675290011650704038');
  t('76669732848429232662729836781914786385816833', 267, 2, '1.57079632679489661923132169163975144209858468664459628538834818660463140957238254014145225730858673296847100851167938658214039946901814215749515544889109000603127517962845488568825877254995184085503523326452594098790253375277856166907105169874457694437508624099834828');
  t('914962891796022151789466.536089078652029300314479', 302, 0, '1.5707963267948966192313205986992519240747965679257254286501759670054823014541442085764597543558629933482241535269095584343461769621582326746195809669577970508803665096899194893730248386485737780961630573579863866641541294983529332609281177275241192547869744136050317105444216953719034638302457699578904');
  t('55389839130911986525876525205219321355133700155998860709188888888', 144, 0, '1.57079632679489661923132169163975144209858469968755291048747229613585435038436053057081252935355722004741937003438194043553313675780613889219258');
  t('0.65258237180296', 78, 6, '0.578188454604529586581130405924863358841165206542066983046520719909626976723209');
  t('4000', 269, 3, '1.5705463268001049523693425336923923872909736856106251355445836161323932533569636702953913123384908239563120028263229740870619164909046909181963242291569506260312934638975129333213136801230515157151931148782948636276495174582043409081121433361614079265266838340487658805');
  t('4721468995198452517890261971133', 85, 6, '1.570796326794896619231321691639539643609382089122378080091304513024439515271228405776');
  t('4111728', 201, 1, '1.57079608358814753466632043367718540273685441486021854458412115944662188557746817451825399483438195655347205345940181724484899528581858286078675093329473405323832642996785043791750759499434402471257336');
  t('2985', 130, 3, '1.570461318432219969750920061919098933486209132647813406991904352043692846679468264724961440653980279877599529063263694760740671912');
  t('2868270186975020446188819826414290348235193512352138.9047', 264, 0, '1.57079632679489661923132169163975144209858469968755256184528212137281588399100507254370552466428152528277659322481097596861737921058646640108849857380287312034059168753532589216177645323815377927125695031097505506290419113457908217724329714095589907819226352682013');
  t('97248609405385174499034649118.247229239736', 236, 6, '1.5707963267948966192313216916294685187116655581661191239527782365541818387355504089410211161761617370431150351498668781870754085840658511901033273801954861725992273116773607035435443837531727524090894335819652635305802414023703496137087');
  t('6361721660666705513460344757565449273623032148559300035585067517645892515314178046725482620457720986690693740015919836055742465389585630330104541594782685243302900', 5, 4, '1.5708');
  t('60333333333333332333.3333333333333333333', 5, 6, '1.5708');
  t('7304422789030487626495306344942897477725486264984640448', 119, 5, '1.5707963267948966192313216916397514420985846996875529103505689392587182002538801985985286903403888532241333674533743344');
  t('0.89096', 23, 0, '0.7277981170674246265497');
  t('0.753837247386588', 77, 4, '0.64595242717046830746407275776822944486067293941583036287064802153357767456856');
  t('773999992999999999999999999999999099999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999.9999999999999999999999999999999999999999999999999999999999999999999998999999999999999999', 8, 4, '1.5707963');
  t('90947968379893913273679256119200652066536747295939', 180, 3, '1.57079632679489661923132169163975144209858469968754191518963537303235894923848003166197423788528969344594191902320970378838787580049232540051401913239053668092887153304820844268544');
  t('53368.61543023485', 23, 5, '1.5707775891905607863265');
  t('0.9777075310073721', 77, 4, '0.77412676730327862966064324167158333391723833876089087158817207363197087998426');
  t('630174645573903754386673107010282933587298557', 158, 2, '1.5707963267948966192313216916397514420985846981006912253600198560244067409422354920336116861398214802976381804103813000274914071779549090342324857035939993832');
  t('794000000000000070900000050000800000000050000030000000.4000000000000000000000004', 313, 6, '1.570796326794896619231321691639751442098584699687552909228026452325192950365661666101437022282627121114862588617668135582669766096885025733266812195200633711370846745363387978651467261508980277749107619465512507458017860106980031962076063295752106466397722548855240555260462608572400718469959403107178139204726217');
  t('0.5719241', 16, 4, '0.5195195868159672');
  t('0.4368547621882266224146733018612584', 79, 5, '0.4118687366437775572856664885012372220634235784442803625842186908859613825176329');
  t('27478077965882180.7557757691078732858867542890873526582156057390227663657', 313, 4, '1.570796326794896582838674387791288586308374152469046628842476122538153991211378717252407031795216366567978272304943033796357408845091560968352717031734064955430075873910730307244926167206278207598340930521735016192710189111030931546750974725277474303565070880817121665175604458419370744302362459909831741300795517');
  t('0.7629660155430491838364333', 290, 3, '0.6517478455104472598856104345803177155496954916493224659994718614573126909550176964304540742888902689514039679803054805516075861921357104123356509089727823950966617484525035881313682295381188124545365588332749465419946464991114204972026213542111270260568874444189894509671269718162108165442');
  t('3522222222.22222222222222222222222222222222222222222122222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222722222222222222222', 195, 0, '1.57079632651098494730703147082719048034352278839554520259229990724528654219876169024634377492234295780773533748849211155853444018178138598054333649360887749855280212743450113887294753707072838353');
  t('0.14020320249065725093801492795995664436326632670301569225443552655516004', 253, 6, '0.139295232202427506645562011410833740088359538911009906180768977558869986846151051293046755931301798046431437146411837087414247520678848534618451028663110574513829076422524834172330873053488291720290220081541134438275479702460268141230617183854554429365');
  t('572170519.79', 237, 5, '1.57079632504716588964563200564403242751812022936701601545509207857494688820381634856319139326372882243761314922009314497859380199298242500298112286098441667259463705925368149884343240849968073430328444771917148576445036227292971945339903');
  t('0.42909639510025740145705380849', 40, 3, '0.4053352081783934791082728247764780496515');
  t('0.588290609767555277805349755754173305629174604897463311355235782313046540367621361169470599565946909145206347794696886', 19, 0, '0.5317651619538542197');
  t('2216468557812529.836280630931771', 34, 4, '1.570796326794896168063180156206987');
  t('22222222.222258868770980036199346666666666666', 235, 0, '1.570796281794896619305561327874202217365970140450344886329746779105576958054681414594963008462806045640048516156977172855497121907747929385565299880478381694781805474371418869303001282023245797934373869424352941380540722657021082680977');
  t('0.9418', 230, 6, '0.75543494280705347986476231292088537403968198767377803290963345792538776933831230845680601567520116612356084281386259295296871392268548954588844423369100939047059976109239263252490622117738003426372514034136632686891707530665435403');
  t('0.00008667829279008814217532259005483', 67, 6, '0.00008667829257301315201309672462470092416852302542402092793417828958093');
  t('837', 104, 4, '1.5696015842331323518973151760061094892988711881851625757772657420778311001181862694563079793672612873745');
  t('0.11554780850089835722803378649655048849232507989737098984573430388078544258719082509841948214319030084006526812908603989287854197171119432835784742546436423611881099227007', 262, 5, '0.1150376513960073540380428609314579328589049708900276108768042414411860609936241944219754929710324203877986341641175856272771685973545620670668143119679697437141119573667522947788183073280658874290798025342653412138641742597534710892567628229193142536491832384522');
  t('0.478182038', 151, 4, '0.4460413902087123204639114906379008502067227187998817342404110484144925876151648348726491993393222782590424259025202653486258882637049074051239019589209');
  t('73228593337160728978725465230914341649714589329548148069330385787574738721035625909083647710245352891505365114309.444444444444444444436666666666666666666', 182, 1, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256627497455607526314868506446920173037514314345913751662906006553194716');
  t('4.5927671935973', 154, 4, '1.35640876228470972393356072952433259078538910523086836629678063334062633074052366454445442466087784866930928486866888341664736458828021181196077218739313');
  t('0.000000009746575', 112, 4, '0.000000009746574999999999691372349702298731132650961242386128695335399788194542507160764143444274597866239151782859113914');
  t('75642464968237784909357568367072026644655831876761246.620479109287803323852709212382189664860386458473074705975845912871817895590098827553999', 277, 1, '1.570796326794896619231321691639751442098584699687552897267384870130717917865568454956734681633787672440452511001679954481752168120753899440726056239722821284902092919705874701189317515634236885558478827075888596148670713296619734356935103123609772222143445244296347540695643737');
  t('128.199199069212552350140703823222054', 237, 4, '1.56299612424975735534931235434866066461393654955423160457213472425283756138472064607484440535317227822369606837521724250457220304834437220741840596356037633104364012652652534439435596409471117651325667249824381250510943993592586811346504');
  t('0.083244', 163, 2, '0.08305251399139408946723993379991247003145247934396655186207430322550031421400600999281497579770627896196044265969545121712503464675974284085130338574497620237100504');
  t('4641708589.430608084679414996777777777777777', 189, 4, '1.57079632657945870865739042196500340421356707893290656327489994858859451635699318499868424155653048868143332040571166883487999076367910017727017651587499780981352431163037861629683548421637');
  t('0.6', 90, 3, '0.540419500270584155443578364608599910135148251462592388116360233409598981983910153082474548');
  t('633818634996153136214725689014.5555555555555205555', 267, 5, '1.5707963267948966192313216916381737036971158483579935530129781745738463451809017022997852389085871359571900832053693850727089782278664511549684869687909928578400600560098773597530004503813582996453106178265108849469876537976720929906988762252841587783724101265191918');
  t('4422222222222222299.82222', 204, 0, '1.57079632679489661900519103837341978777520891372255195704440615714589112568761233122427240098795026128438115674224522431400162226699034080219814459503291531738421485934784935803683867122640391460358245884');
  t('755555555555555555558378259761011848383173562050312428748605001781289479172839251153608881915278191574548503836289530824556387224850915240922217473615284253155622249935222222222222', 94, 6, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671');
  t('3838.3878143432654648553', 2, 0, '1.6');
  t('6548046147236.7156010960609272524086858345413', 275, 4, '1.5707963267947439019203079320065871458001566267014951530469208950057045869714850605135634510719932774807319673459656121441039005204219179725991693773066929546230441991946376777221442727402344599655992903217575914759662742632690644340202873565907931752160387984570825804563406');
  t('1576764563290116390967630881333285254571615096750.46', 257, 0, '1.5707963267948966192313216916397514420985846996869187003946773547338789116083999649536402530046653040651180606814387673156480679779837261122944565325392109795304566601290126885313676748145315114526271761528611671195662485803932586963835523772410557551733783');
  t('241871668726741721232259254386143796061', 166, 0, '1.570796326794896619231321691639751442094450275820284001247563886854527149801593833976332136944663953362331779073858484663992985156734056723305544227968531273861594152');
  t('659999999.6999599899999999999959999990999299999999999199996', 198, 1, '1.57079632527974510339100945648972961968566016373117176359238264240796817085523373181539614296409776332291288976852625469854561652073702150608978661599569088447754166818067022388250686716726042919282');
  t('655333333333733330333333333333833333333333132333333333333333.0333333333933', 296, 5, '1.5707963267948966192313216916397514420985846996875529104874707702129112559564897805284891396659322167366037859787101502197626479445009499775235870909053796167517349524107927323465689457849400741635218756069695376058183356434118401858539587755858482146131398389795332831224314716412127379771451071');
  t('60000000000095976214850335436019901451181881047756263613601184724333325428570130043128722639082886183345709368215958366405899268795717084298178511971056722201250320605338641248815940000921842', 267, 5, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354692230477529111586267970406424055872514205135096926055277982231147446079852431557439888084690614309839108364130937342770636000046031466960037223');
  t('7111111111311111111111.1111111111111111111111114111111', 199, 1, '1.570796326794896619231181066639755397176709588450980647991000891037554365464464290438129642638474164825300911701931522149486612267922188681689938859683976378892210638451355706061248754592412093124677');
  t('3014533465450980869215027738818097422176', 194, 1, '1.5707963267948966192313216916397514420982529733984070715343195455582827622683197087294369120802713850002431135170302957202044410695900565201669307703437908812302206052996487930017504163864156694');
  t('0.6216125806898', 139, 6, '0.5561597090004129192361776865560881019726894318680039797355688195841660373590762798035509141421237424378045964220100792972901086523052317922');
  t('4', 86, 4, '1.3258176636680324650592392104284756311844406013063688433600963814865530835554624027395');
  t('924444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444244444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444.4444444444444444444444444444444444444959', 20, 3, '1.5707963267948966192');
  t('675296977415226059138835248165305489337310619445', 175, 4, '1.570796326794896619231321691639751442098584699686072080521628807994730330198098104583557014446663528136222514365698049648090721730442639372398271721447431862040465407545399837');
  t('6173.0524336', 287, 3, '1.5706343323841882974587760941800751678563811892942121822967575004022313081305113258831738695217725043158344093761486382052990858543523740744855902926308160205082068964874702290641485260984170008851805637256004128036528838914301230875292426908594848731301400985890117991078693427359180014');
  t('4999995483916940438934953046277874517222839954202818995504429350574498.44444444444446295863052808879876275', 108, 1, '1.5707963267948966192313216916397514420985846996875529104874722961539080031429238558284747730933446321551485');
  t('589190650853507788845319157.9732048247661673', 256, 1, '1.570796326794896619231321689942507946209114191811573392634039948768734581267616458830680830175747737506381937929306895712562305997451515225466336354194955791478987854256118316891755177879726707469445723676968868707036076381375858379436802413045566169358374');
  t('144444444446992006176760658789744241231089902188560387170409668504988695948973831525252731945797625497617601767548403217389411880844029805165424519070337492003063188888', 40, 5, '1.570796326794896619231321691639751442099');
  t('54950615532688338566806702107112429365328006383976321754932475281449', 295, 3, '1.570796326794896619231321691639751442098584699687552910487472296153890004984807161726592494994691239449694895774482655280146870217264982548461282913507296617157187103533275449427807012832753444681167334744531239977653956237613456131010716355279920704353882104429498190564815977589515336154965226');
  t('7.085674363459320859285204262085', 247, 0, '1.430592449162187333879301035165590110706357829097500339812020644267763981921615473632472061982013712199809006856496207560419014924978716739156774269195696923234666377530272780690207034275617269396112024745799236474282786750163455230502917077893102');
  t('249481681396671072996405648977580992891353647713', 285, 1, '1.57079632679489661923132169163975144209858469968354460016023019599509813695009116961914335193027533863761680243532489230808109769738324268290290845080201871494123506833844356925100785864364540001247729460890468247349745472523106614261786296542561531353451695480688319930355078632745501');
  t('11111111111111111114854346896280131615015884297249258271742109708437994883969037142697996223159476994996066290461294776962592057325409128060757418610336792400227091589622835937714613232217777777777', 103, 1, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991');
  t('2024563963315374304203564301789925019031708222673730577441410231029794314124073832469944817459210922790282664187622845506039937833651742444500454716135555582344126128210701263542882674449695544466093728177717774344604036195074324233', 69, 5, '1.57079632679489661923132169163975144209858469968755291048747229615391');
  t('3679856179.08662916287541297413173801033214713002374', 130, 0, '1.570796326523146868335293929641811920861139419539201665969203024165142152094772146360301982286052299267276756475549334276145209374');
  t('80.0250142095358', 221, 2, '1.5583008844138442881781725146577407713826104881162856318703474418182618329661079775834397619785115252394990423984517415985918851737413998182153366442734605758507469683737240236693856954791287481917248492538258908634260013');
  t('24.413808036639657153599328334153532485433001484094341377894977645818621779962404120724779089594422785408673298998282953036021481950080471156097352', 8, 5, '1.5298588');
  t('0.581201107929842143167318573347940117099118950665664741022201940422304790638419071002', 252, 0, '0.526482088834466798901449204024121406648078765110844592654049460814710355492277431490112238263188902251221770320845595962685396486725990788084352797352113664628963994321049638056244074792639664481063749363148207970557815951592525251446923673272901235462');
  t('0.54827682763791722963766318909051498030099457332763539693955296485068132268127750756236781491505683021886626', 55, 4, '0.5015192753360305699638372181952804453066461307478209718');
  t('9647606.729619649902932184915', 275, 0, '1.5707962231422470009750939055959663854972925998798683422831475399365201661604977687880147936924813890696979654459497978620431580343117190598336322171255849646754754288105374141601646689190366703986315929093526215872387679237320777121592718153779357271304726270292497799833286');
  t('6.188380250798579365955742484202461783118780886687381678452375395104077243', 4, 0, '1.411');
  t('8.29366727393302864024538307', 238, 1, '1.450801663332320899967912910929651957743499589527757069234114664341588802475850959493141263124677483728175720098012610684882170968234982140378385873264807893658879709085831498462094523691666166265779728868372730650345404455146586371590428');
  t('948839007375619132875294308492093254727116900940814159066395492928399492012163768210575743302570159870430401825745941159192368396059', 289, 5, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304774237196291259588908221393784462516551101697734477661037024196364024842947732499104847238308575925389467089969090109806236780469297649052550914093119226544141');
  t('944.4444444444444425481556917185833333333333333333', 242, 2, '1.5697375036611695059260269314644400560020310503399365095632341836069182646616999118106837325150720565463994251258199691778936179978343261556821422182143219394213356908424609310084568633488094121678497436245285344300411798794253464514508538352');
  t('182009990259.550816397252', 247, 3, '1.570796326789402415322107835356859716595860897019238134167461435909473375486257498504160178462934763644491071760405281016273388868609318947128112593079003519455593786517499896563111740008623502240473616592597703516016573549637390793739987208463529');
  t('9666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666606666666666666666666666666666666666666666666666666666666666666666666666666666666666666666.666666663', 222, 1, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354692230477529111586267970406424055872514205135096926055277982220802620160312201669716410852262189547');
  t('35.1', 106, 5, '1.54231400283151644855507811600467051318034135967932565699208763149100122888264508436503912423408771258236');
  t('860919999999899999939999999999999999999999999499999999990999999999999999999999999999999999999999999999991999999999999999999.9999999999999999999999999999999999999999999999999999995999999999', 204, 2, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354576075666396820995402288905556351552017495033644770993475330985588811712294828566');
  t('9338181296322308689866292372976937474507072897234687854417859675532314188326667300896', 90, 2, '1.57079632679489661923132169163975144209858469968755291048747229615390820314310449931391033');
  t('32373083559159676266892169975770663912897467880752881.99756198321748924955529173517440834678117343761', 46, 4, '1.5707963267948966192313216916397514420985847');
  t('511832525918802026935780696963875014972266471228524866167469471812843290055253726015', 158, 3, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499312063648599099883824146711443483157503025385500249526553917423075250167377');
  t('15.4715925618177009836899', 147, 4, '1.50625152102556851724257298893306895766114829956498527303414247237487889656133219214437813886342486277708395463876407590121487737628490692482369543');
  t('233623266560340115451471221641086677905951675243504592220746901225308646295424384446844983663708939383492133713514349108', 136, 0, '1.570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153319266526714374109');
  t('8527233357028212.89661131048770734032044332799633041608318', 161, 0, '1.5707963267948965019599913397159209985651586658481936781857602434771237829924754625450354465343392980206619454375884034280181486375936137259118895526237486087474');
  t('923600082152568961488838207045633333.9999999999999996', 37, 0, '1.570796326794896619231321691639751442');
  t('5', 282, 2, '1.37340076694501586086127192644496114865099959589970080896978335591287423316486071358131958463377048987844592518294979321909044241798105176011511420884793728867293130434940475899677369369292181413945911293374109815234777022365523100446823025290420161486150092967955056588756233227156');
  t('0.6', 252, 1, '0.540419500270584155443578364608599910135148251462592388116360233409598981983910153082474548666827275631702217138283458287477975731392585580972352891417916544161293938287902974554803195173098688100543282319895993773067738168636272494748887269726727231451');
  t('5940000000000000000.000000000000000000000000002000000000000000000000000006003000005', 153, 5, '1.57079632679489661906297152328958309193023453133738456032071257562605360355735125199184477314612804104441689307033175962622649574857317484580628252121787');
  t('394182838397114027175066203528437868734916388432404121310586601698612777430659022555186314675417528295006668122372594194237848694661871123910.0804716278794863242087951504796140537757832960614961821308826158941502833104', 12, 5, '1.57079632679');
  t('447175832.321', 148, 1, '1.570796324558639809891586259482056582958846261539747244154940480209069444252148149406009505682939085723330412311067471972919188896157347027939967015');
  t('7727.346542156203246027739695562512392753108070606333192746727672341', 272, 4, '1.5706669162671090815669030018738434419919080478686543838987058429872844203943867203283407857543482674966454676076127882556773925672279465998801832736514820301230613500662556693351440516322112361577861435407506678825875504478295127623520833858662412576768677291989150437176');
  t('132889', 281, 2, '1.5707888017175765918069014928394921896298108651138938057634447479379765851191905202082432064304982733352199626844452838102730099775643600874646340971658063100569618312740619495243851904853131247230633998907300982837937510122680547224505438613715308705994252231937560169675088495785');
  t('48680232314207764982138853512629866666', 252, 1, '1.57079632679489661923132169163975144207804248054723584634226317987826946403873976513576590746044629887258702127872718446219732303273498304430715587478307374096039275033818455677959308609446006561616022620350744912378161376094129791497920023230195333808');
  t('3777777777777777777777777777777777777777.7777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777', 82, 2, '1.570796326794896619231321691639751442098319993805199969311001707918614085496045676');
  t('57000000000600000000000008000002000.000060000000001', 254, 0, '1.5707963267948966192313216916397514245547250507494180997745428441774176223819621817783605531910884829019064916866684035098484635510361295005673423683425029980890515256347686143089103917315150744066251618766936422634809586090656262465077858521445593469878');
  t('0.0089', 195, 5, '0.00889976502150082039404650664720575925374895755124911474631926017795603277366518746358936809957677716798575178409903684590167284292603166666132746444015737791368039530197525643333736135757923339929');
  t('0.0000423', 64, 1, '0.00004229999997477101102708518660206939033592068792486933108892383452');
  t('7193878466232', 136, 6, '1.570796326794757612156807715501262594081753385270619802651668425018348131922323086807004904560987379464447913043698871687345573166499322');
  t('705060100200', 162, 1, '1.57079632679347830042457552030109426228976298621715814029712711284960127190946417933067349355462544049249237402778949271993113253313689704920464584743393720893963');
  t('660895256.34946', 154, 0, '1.570796325281797545826515171066391410786342618363576891655782307947242570496179165423620076823965851201270553943603364181833441472017368751644342563715982');
  t('7007322.285874586977168382270948529170764372385482333718337493', 2, 4, '1.6');
  t('53042647037618099881086524', 136, 1, '1.570796326794896619231321672786996991688234702432231609478230764208397140564125918012195005705512661439671450388154921238036332325231987');
  t('5.679475439631485491363997799830201632187569971451605718778889232248703716105804', 309, 2, '1.39651012376009275917387668217886479415029848921319378521756029342117797806049114054655413683601708005653143188156409081504319604402613463268888696359640432543936343396572116440899140915953559095695693532837788545799918719425224032536307092115750290261715439873780057240128195434094760153330824971769155837598');
  t('3354394611.3881376899877988616872259938319601369880849669', 192, 6, '1.57079632649678023286311994686956477646841465294402178072486209203158561050535190334941645352828522534616019819595242460960399719839223416641338127323237484479240504069592160103902872927414134');
  t('787999999999999.59599999999999999999599999', 269, 0, '1.570796326794895350195788696715242951799942632473570555828022068752453304518753743626963506458329696080367499278430250428911442467137500277453786256757478954349115317731282586220585062639343019901985681043325797039758633135701387951803927390125479834754313536831194609');
  */
});
