/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include "Task.h"
#include "IconObject.h"
#include "Input.h"


class ShellTask : public Task, public Input
{
public:
    ShellTask(const std::string&, IconObject*);
    virtual ~ShellTask();

    virtual void addContext(const Request&) {}

protected:
    void print(std::ostream&) const;
    void Object(IconObjectH xx) { object_ = xx; }

    // From Task
    virtual void start();
    // From Input
    virtual void done(FILE*);

private:
    // No copy allowed
    ShellTask(const ShellTask&);
    ShellTask& operator=(const ShellTask&);

    IconObjectH object_;
    FILE* file_;
    std::string cmd_;

    // From Input
    virtual void ready(const char*);
};

inline void destroy(ShellTask**) {}
