; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basic-aa -slp-vectorizer -S -mcpu=corei7-avx | FileCheck %s --check-prefixes=ANY,AVX
; RUN: opt < %s -basic-aa -slp-vectorizer -slp-max-reg-size=128 -S -mcpu=corei7-avx | FileCheck %s --check-prefixes=ANY,MAX128

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @store_chains(double* %x) {
; AVX-LABEL: @store_chains(
; AVX-NEXT:    [[TMP1:%.*]] = bitcast double* [[X:%.*]] to <4 x double>*
; AVX-NEXT:    [[TMP2:%.*]] = load <4 x double>, <4 x double>* [[TMP1]], align 8
; AVX-NEXT:    [[TMP3:%.*]] = fadd <4 x double> [[TMP2]], [[TMP2]]
; AVX-NEXT:    [[TMP4:%.*]] = fadd <4 x double> [[TMP3]], [[TMP2]]
; AVX-NEXT:    [[TMP5:%.*]] = bitcast double* [[X]] to <4 x double>*
; AVX-NEXT:    store <4 x double> [[TMP4]], <4 x double>* [[TMP5]], align 8
; AVX-NEXT:    ret void
;
; MAX128-LABEL: @store_chains(
; MAX128-NEXT:    [[TMP1:%.*]] = bitcast double* [[X:%.*]] to <2 x double>*
; MAX128-NEXT:    [[TMP2:%.*]] = load <2 x double>, <2 x double>* [[TMP1]], align 8
; MAX128-NEXT:    [[TMP3:%.*]] = fadd <2 x double> [[TMP2]], [[TMP2]]
; MAX128-NEXT:    [[TMP4:%.*]] = fadd <2 x double> [[TMP3]], [[TMP2]]
; MAX128-NEXT:    [[TMP5:%.*]] = bitcast double* [[X]] to <2 x double>*
; MAX128-NEXT:    store <2 x double> [[TMP4]], <2 x double>* [[TMP5]], align 8
; MAX128-NEXT:    [[TMP6:%.*]] = getelementptr inbounds double, double* [[X]], i64 2
; MAX128-NEXT:    [[TMP7:%.*]] = bitcast double* [[TMP6]] to <2 x double>*
; MAX128-NEXT:    [[TMP8:%.*]] = load <2 x double>, <2 x double>* [[TMP7]], align 8
; MAX128-NEXT:    [[TMP9:%.*]] = fadd <2 x double> [[TMP8]], [[TMP8]]
; MAX128-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP9]], [[TMP8]]
; MAX128-NEXT:    [[TMP11:%.*]] = bitcast double* [[TMP6]] to <2 x double>*
; MAX128-NEXT:    store <2 x double> [[TMP10]], <2 x double>* [[TMP11]], align 8
; MAX128-NEXT:    ret void
;
  %1 = load double, double* %x, align 8
  %2 = fadd double %1, %1
  %3 = fadd double %2, %1
  store double %3, double* %x, align 8
  %4 = getelementptr inbounds double, double* %x, i64 1
  %5 = load double, double* %4, align 8
  %6 = fadd double %5, %5
  %7 = fadd double %6, %5
  store double %7, double* %4, align 8
  %8 = getelementptr inbounds double, double* %x, i64 2
  %9 = load double, double* %8, align 8
  %10 = fadd double %9, %9
  %11 = fadd double %10, %9
  store double %11, double* %8, align 8
  %12 = getelementptr inbounds double, double* %x, i64 3
  %13 = load double, double* %12, align 8
  %14 = fadd double %13, %13
  %15 = fadd double %14, %13
  store double %15, double* %12, align 8
  ret void
}

define void @store_chains_prefer_width_attr(double* %x) #0 {
; ANY-LABEL: @store_chains_prefer_width_attr(
; ANY-NEXT:    [[TMP1:%.*]] = bitcast double* [[X:%.*]] to <2 x double>*
; ANY-NEXT:    [[TMP2:%.*]] = load <2 x double>, <2 x double>* [[TMP1]], align 8
; ANY-NEXT:    [[TMP3:%.*]] = fadd <2 x double> [[TMP2]], [[TMP2]]
; ANY-NEXT:    [[TMP4:%.*]] = fadd <2 x double> [[TMP3]], [[TMP2]]
; ANY-NEXT:    [[TMP5:%.*]] = bitcast double* [[X]] to <2 x double>*
; ANY-NEXT:    store <2 x double> [[TMP4]], <2 x double>* [[TMP5]], align 8
; ANY-NEXT:    [[TMP6:%.*]] = getelementptr inbounds double, double* [[X]], i64 2
; ANY-NEXT:    [[TMP7:%.*]] = bitcast double* [[TMP6]] to <2 x double>*
; ANY-NEXT:    [[TMP8:%.*]] = load <2 x double>, <2 x double>* [[TMP7]], align 8
; ANY-NEXT:    [[TMP9:%.*]] = fadd <2 x double> [[TMP8]], [[TMP8]]
; ANY-NEXT:    [[TMP10:%.*]] = fadd <2 x double> [[TMP9]], [[TMP8]]
; ANY-NEXT:    [[TMP11:%.*]] = bitcast double* [[TMP6]] to <2 x double>*
; ANY-NEXT:    store <2 x double> [[TMP10]], <2 x double>* [[TMP11]], align 8
; ANY-NEXT:    ret void
;
  %1 = load double, double* %x, align 8
  %2 = fadd double %1, %1
  %3 = fadd double %2, %1
  store double %3, double* %x, align 8
  %4 = getelementptr inbounds double, double* %x, i64 1
  %5 = load double, double* %4, align 8
  %6 = fadd double %5, %5
  %7 = fadd double %6, %5
  store double %7, double* %4, align 8
  %8 = getelementptr inbounds double, double* %x, i64 2
  %9 = load double, double* %8, align 8
  %10 = fadd double %9, %9
  %11 = fadd double %10, %9
  store double %11, double* %8, align 8
  %12 = getelementptr inbounds double, double* %x, i64 3
  %13 = load double, double* %12, align 8
  %14 = fadd double %13, %13
  %15 = fadd double %14, %13
  store double %15, double* %12, align 8
  ret void
}

attributes #0 = { "prefer-vector-width"="128" }
