/*
 * Copyright (C) 2023  Daniel García Moreno <danigm@gnome.org>
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "gtr-msg.h"

G_BEGIN_DECLS

#define GTR_TYPE_MESSAGE_TABLE_ROW (gtr_message_table_row_get_type ())
G_DECLARE_FINAL_TYPE (GtrMessageTableRow, gtr_message_table_row, GTR, MESSAGE_TABLE_ROW, GtkBox)

/*
 * Public methods
 */
GtkWidget *gtr_message_table_row_new (void);
void gtr_message_table_row_set_msg (GtrMessageTableRow *row, GtrMsg *msg);

G_END_DECLS

