Version 0.9 has been released to coincide with the official publication of the
Elvish website, which will be hosting all release notes in the future.

This version is released slightly more than a month after 0.8. Despite the short
interval, there are some interesting additions and changes.

# Breaking Changes

-   Lists have become immutable.

    Support for assigning individual list elements has been temporarily removed.
    For instance, the following is no longer possible:

    ```elvish
    li = [lorem ipsum foo bar]
    li[1] = not-ipsum
    ```

    You need to use this for now:

    ```elvish
    li = [(explode $li[:1]) not-ipsum (explode $li[2:])]
    ```

    Element assignment will be reintroduced as a syntax sugar, after the
    conversion to persistent data structure is finished.

    Assignments to map elements are not affected.

-   The `true` and `false` builtin commands have been removed. They have been
    equivalent to `put $true` and `put $false` for a while.

-   The default keybinding for last command mode has been changed from <span
    class="key">Alt-,</span> to <span class="key">Alt-1</span>.

-   The "bang mode" is now known as "last command mode".

-   The `le:` module (for accessing the Elvish editor) has been renamed to
    `edit:`. You can do a simple substitution `s/le:/edit:/g` to fix your
    `rc.elv`.

-   The 3 listing modes -- location mode, history listing mode and last command
    mode -- are being merged into one generic listing mode.

    Most of their builtins have been merged: for instance, they use to come with
    their own builtins for changing focused candidate, `le:loc:up`,
    `le:histlist:up` and `le:bang:up`. These have been merged into simply
    `edit:listing:up`, that operates on whichever listing mode is active.

    A new binding table, `$edit:binding[listing]` has also been introduced.
    Bindings put there will be available in all 3 listing modes, with bindings
    in their own tables (`$edit:binding[loc]`, `$edit:binding[histlist]` and
    `$edit:binding[lastcmd]`) having higher precedence.

-   The readline-style binding module has been renamed from
    `embedded:readline-binding` to just `readline-binding`. Future embedded
    modules will no longer have an `embedded:` prefix either.

# Notable Fixes and Enhancements

-   This release has seen more progress towards breaking up the huge, untested
    [edit](https://github.com/elves/elvish/tree/master/edit) package. For
    instance, the syntax highlighter and command history helpers now live in
    their own packages, and have better test coverages.

-   An experimental web interface has been added. It can be used by supplying
    the `-web` flag when running Elvish, i.e. `elvish -web`. The default port is
    3171, which is [a way](https://en.wikipedia.org/wiki/Leet) to write "ELVI".
    An alternative port can be specified using `-port`, e.g.
    `elvish -web -port 2333`.

-   Per-session command history has been reintroduced
    ([#355](https://github.com/elves/elvish/issues/355)).

-   Elvish now forks a daemon for mediating access to the database. This is to
    prepare for the switch to a pure Go database and removing the current C
    dependency on SQLite. A new `daemon:` module has been introduced.

-   A new `edit:complex-candidate` builtin has been introduced to construct
    complex candidates from completers.

-   A new `re:` module, containing regular expression utilities, has been
    introduced.

# Known Issues

The daemon implementation has a known issue of some intermediate process not
being reaped correctly and there is an outstanding
[pull request](https://github.com/elves/elvish/pull/373/) for it. In the worst
case, this will leave 2 processes hanging in the system.
