/*
 * map-font with marking
 */
#include	"defs.h"
#include	"global.h"
#include	"bifont.h"

#define	NJISCHARS	(94*94)

static struct biinitfontinfo *
alloc_bi(bi, nchars, s)
struct bifont *bi;
int nchars;
char *s;
{
    int i;
    struct biinitfontinfo *bii;

    bii = (struct biinitfontinfo *)
	alloc_check(malloc((unsigned)sizeof(struct biinitfontinfo)+
			   (nchars-1)*sizeof(Boolean)),
		    s);
    for (i = 0; i < nchars; i++)
	bii->mark[i] = FALSE;
    bii->maxc = 0;
    bii->bf = bi;
    return bii;
}

struct biinitfontinfo *
alloc_biinif(bi)
struct bifont *bi;
{
    return alloc_bi(bi, NTFMCHARS, "biinitfontinfo");
}

struct biinitfontinfo *
alloc_jbiinif(bi)
struct bifont *bi;
{
    return alloc_bi(bi, NJISCHARS, "j-biinitfontinfo");
}

jmm_markchar(c)
int c;
{
    c = jis_to_idx94(c);
    biinifinfo(curfontent)->mark[c] = TRUE;
    if (c > biinifinfo(curfontent)->maxc)
	biinifinfo(curfontent)->maxc = c;
}

mm_markchar(c)
int c;
{
    biinifinfo(curfontent)->mark[c] = TRUE;
    if (c > biinifinfo(curfontent)->maxc)
	biinifinfo(curfontent)->maxc = c;
}

jsmm_markchar(c)
int c;
{
    struct jstfmfntinfo *jsfi = jstfmfinfo(curfontent);
    struct biinitfontinfo *bii;

    c = jsub_to_idx94(jsfi->jsubfont, c);
    bii = (struct biinitfontinfo *)jsfi->js_info;
    bii->mark[c] = TRUE;
    if (c > bii->maxc)
	bii->maxc = c;
}
